/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.utils;

import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.ImageIcon;
import joptsimple.ValueConversionException;
import org.spigotmc.builder.Bootstrap;
import org.spigotmc.builder.PullRequest;
import org.spigotmc.builder.Repository;
import org.spigotmc.gui.BuildToolsGui;

public class Utils {
    public static String getFileContentsFromResource(String resource) {
        String contents;
        URL url = Resources.getResource(resource);
        try {
            contents = Resources.toString(url, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return contents;
    }

    public static String getReadableStacktrace(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append(throwable.getMessage());
        builder.append("\n");
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            builder.append(stackTraceElement.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String getHexFromColor(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    public static File getFile() {
        try {
            return new File(Utils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImageIcon getIcon(String fileName) {
        ImageIcon imageIcon;
        block8: {
            InputStream input = BuildToolsGui.class.getClassLoader().getResourceAsStream(fileName);
            try {
                imageIcon = new ImageIcon(ByteStreams.toByteArray(input));
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            input.close();
        }
        return imageIcon;
    }

    public static <T> T randomElement(T normal, T easterEgg, int oneOver) {
        return ThreadLocalRandom.current().nextInt(oneOver) == 0 ? easterEgg : normal;
    }

    public static boolean isRanFromJar() {
        String classPath = Bootstrap.class.getName().replace('.', '/');
        String classJar = Bootstrap.class.getResource("/" + classPath + ".class").toString();
        return classJar.startsWith("jar:");
    }

    public static boolean isRanFromCommandLine() {
        return System.console() != null;
    }

    public static boolean isValidPR(String input, Repository repository) {
        PullRequest request = null;
        try {
            request = new PullRequest.PullRequestConverter().convert(input);
        }
        catch (ValueConversionException valueConversionException) {
            // empty catch block
        }
        if (request == null) {
            return false;
        }
        return request.getRepository() == repository;
    }

    public static boolean isValidSpigotPR(String input) {
        return Utils.isValidPR(input, Repository.SPIGOT);
    }

    public static boolean isValidBukkitPR(String input) {
        return Utils.isValidPR(input, Repository.BUKKIT);
    }

    public static boolean isValidCraftbukkitPR(String input) {
        return Utils.isValidPR(input, Repository.CRAFTBUKKIT);
    }

    public static boolean isValidPath(String input) {
        File file = new File(input);
        if (!file.isDirectory()) {
            return false;
        }
        return file.canWrite();
    }

    public static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

