/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.panels.options;

import com.jeff_media.javafinder.JavaFinder;
import com.jeff_media.javafinder.JavaInstallation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileSystemView;
import org.spigotmc.builder.Builder;
import org.spigotmc.gui.components.CustomFocusTraversalPolicy;
import org.spigotmc.gui.components.PlaceholderTextField;
import org.spigotmc.gui.data.BuildData;
import org.spigotmc.gui.data.BuildSettings;
import org.spigotmc.gui.modals.SelectJavaModal;
import org.spigotmc.gui.panels.general.GeneralPanel;
import org.spigotmc.gui.panels.options.flags.FlagCompileChangesPanel;
import org.spigotmc.gui.panels.options.flags.FlagDontUpdatePanel;
import org.spigotmc.gui.panels.options.flags.FlagGenerateSourcesPanel;
import org.spigotmc.gui.panels.options.flags.FlagJavadocsPanel;
import org.spigotmc.gui.panels.options.flags.FlagRemapPanel;
import org.spigotmc.gui.panels.options.flags.FlagSkipHTTPSCheckPanel;
import org.spigotmc.gui.panels.options.flags.FlagSkipJavaVersionCheckPanel;
import org.spigotmc.utils.Constants;
import org.spigotmc.utils.SwingUtils;
import org.spigotmc.utils.Utils;

public class OptionsPanel
extends JPanel {
    private CustomFocusTraversalPolicy traversalPolicy;
    private JTextField javaExecutableField;
    private JButton detectJavaButton;
    private JButton javaSelectionButton;
    private JCheckBox compileNoneCheckbox;
    private JCheckBox compileSpigotCheckbox;
    private JCheckBox compileCraftbukkitCheckbox;
    private final GeneralPanel panel;
    private final BuildData buildData;
    private final BuildSettings buildSettings;

    public OptionsPanel(GeneralPanel generalPanel, BuildData buildData, BuildSettings buildSettings) {
        this.buildData = buildData;
        this.buildSettings = buildSettings;
        this.panel = generalPanel;
        this.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.setPreferredSize(new Dimension(1200, 700));
        this.initComponents();
    }

    private void initComponents() {
        JLabel buildFlagsLabel = new JLabel("<html><b>Build Flags</b></html>");
        JLabel pullRequestsLabel = new JLabel("<html><b>Pull Request IDs (Optional)</b></html>");
        JLabel compilationOptionsLabel = new JLabel("<html><b>Compilation Options</b></html>");
        JLabel javaConfigurationLabel = new JLabel("<html><b>Additional Configuration</b></html>");
        PlaceholderTextField spigotPrTextField = new PlaceholderTextField();
        spigotPrTextField.setPlaceholder("SPIGOT PR:ID");
        spigotPrTextField.setToolTipText("Example: SPIGOT:42");
        spigotPrTextField.setMargin(new Insets(8, 8, 8, 8));
        spigotPrTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OptionsPanel.this.spigotPrFieldKeyReleased(keyEvent);
            }
        });
        PlaceholderTextField bukkitPrTextField = new PlaceholderTextField();
        bukkitPrTextField.setPlaceholder("BUKKIT PR:ID");
        bukkitPrTextField.setToolTipText("Example: BUKKIT:28");
        bukkitPrTextField.setMargin(new Insets(8, 8, 8, 8));
        bukkitPrTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OptionsPanel.this.bukkitPrFieldKeyEvent(keyEvent);
            }
        });
        PlaceholderTextField craftbukkitPrTextField = new PlaceholderTextField();
        craftbukkitPrTextField.setPlaceholder("CRAFTBUKKIT PR:ID");
        craftbukkitPrTextField.setToolTipText("Example: CRAFTBUKKIT:207");
        craftbukkitPrTextField.setMargin(new Insets(8, 8, 8, 8));
        craftbukkitPrTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OptionsPanel.this.craftbukkitPrFieldKeyEvent(keyEvent);
            }
        });
        this.compileNoneCheckbox = OptionsPanel.createCompilationOption("NONE", "--compile none", this::compileNoneCheckboxActionPerformed);
        this.compileSpigotCheckbox = OptionsPanel.createCompilationOption("SPIGOT", "--compile spigot", this::compileSpigotCheckboxActionPerformed);
        this.compileCraftbukkitCheckbox = OptionsPanel.createCompilationOption("CRAFTBUKKIT", "--compile craftbukkit", this::compileCraftbukkitCheckboxActionPerformed);
        JCheckBox overrideJavaCheckbox = new JCheckBox("Override Java Executable");
        overrideJavaCheckbox.addActionListener(event -> this.overrideJavaCheckboxActionPerformed(overrideJavaCheckbox));
        JLabel javaExecutableLabel = new JLabel("Java Executable");
        this.javaExecutableField = new JTextField();
        this.javaExecutableField.setFont(Constants.GENERAL_FONT);
        this.javaExecutableField.setToolTipText("Path to the java executable you want to use.");
        this.javaExecutableField.setMargin(new Insets(8, 8, 8, 8));
        this.javaExecutableField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                OptionsPanel.this.javaExecutableFieldKeyReleased(event);
            }
        });
        this.javaExecutableField.setEnabled(false);
        this.detectJavaButton = new JButton("Detect & Choose");
        this.detectJavaButton.setToolTipText("Select the java executable.");
        this.detectJavaButton.setMargin(new Insets(8, 16, 8, 16));
        this.detectJavaButton.addActionListener(this::detectJavaButtonActionPerformed);
        this.detectJavaButton.setEnabled(false);
        this.detectJavaButton.setCursor(Cursor.getPredefinedCursor(12));
        this.javaSelectionButton = new JButton("Select");
        this.javaSelectionButton.setToolTipText("Select the java executable");
        this.javaSelectionButton.setMargin(new Insets(8, 16, 8, 16));
        this.javaSelectionButton.addActionListener(this::selectJavaButtonActionPerformed);
        this.javaSelectionButton.setEnabled(false);
        this.javaSelectionButton.setCursor(Cursor.getPredefinedCursor(12));
        JLabel jvmArgumentsLabel = new JLabel("JVM Arguments");
        JTextField jvmArgumentsField = new JTextField("-Xms512M");
        jvmArgumentsField.setToolTipText("Any additional JVM flags that you want to set.");
        jvmArgumentsField.setFont(Constants.GENERAL_FONT);
        jvmArgumentsField.setMargin(new Insets(8, 8, 8, 8));
        jvmArgumentsField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OptionsPanel.this.jvmArgumentsFieldKeyReleased(keyEvent);
            }
        });
        JLabel workDirLabel = new JLabel("Working Directory");
        JTextField workDirField = new JTextField(Builder.CWD.toString());
        workDirField.setToolTipText("The directory BuildTools will run in.");
        workDirField.setMargin(new Insets(4, 8, 4, 8));
        workDirField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OptionsPanel.this.workDirectoryFieldKeyRelease(keyEvent);
            }
        });
        this.buildSettings.setWorkDirectory(workDirField.getText());
        FlagRemapPanel flagRemapPanel = new FlagRemapPanel(this.buildSettings);
        FlagJavadocsPanel flagJavadocsPanel = new FlagJavadocsPanel(this.buildSettings);
        FlagGenerateSourcesPanel flagGenerateSourcesPanel = new FlagGenerateSourcesPanel(this.buildSettings);
        FlagCompileChangesPanel flagCompileChangesPanel = new FlagCompileChangesPanel(this.buildSettings);
        FlagSkipHTTPSCheckPanel flagSkipHTTPSCheckPanel = new FlagSkipHTTPSCheckPanel(this.buildSettings);
        FlagSkipJavaVersionCheckPanel flagSkipJavaVersionCheckPanel = new FlagSkipJavaVersionCheckPanel(this.buildSettings);
        FlagDontUpdatePanel flagDontUpdatePanel = new FlagDontUpdatePanel(this.buildSettings);
        JSeparator verticalSeparator0 = new JSeparator(1);
        JSeparator verticalSeparator1 = new JSeparator(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(flagGenerateSourcesPanel, -2, -1, -2).addComponent(flagCompileChangesPanel, -2, -1, -2).addComponent(flagSkipHTTPSCheckPanel, -2, -1, -2).addComponent(flagSkipJavaVersionCheckPanel, -2, -1, -2).addComponent(buildFlagsLabel, -2, -1, -2).addComponent(flagDontUpdatePanel, -2, -1, -2).addComponent(flagRemapPanel, -2, -1, -2).addComponent(flagJavadocsPanel, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(spigotPrTextField).addComponent(bukkitPrTextField).addComponent(craftbukkitPrTextField))).addComponent(pullRequestsLabel, -2, -1, -2)).addGap(32, 32, 32).addComponent(verticalSeparator0, -2, -1, -2).addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(compilationOptionsLabel, -2, -1, -2).addComponent(this.compileNoneCheckbox).addComponent(this.compileSpigotCheckbox).addComponent(this.compileCraftbukkitCheckbox)).addGap(32, 32, 32).addComponent(verticalSeparator1, -2, -1, -2).addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(javaConfigurationLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(overrideJavaCheckbox)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(javaExecutableLabel).addComponent(jvmArgumentsLabel).addComponent(workDirLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.javaExecutableField, -1, 408, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detectJavaButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaSelectionButton)).addComponent(jvmArgumentsField).addComponent(workDirField)))))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(buildFlagsLabel, -2, -1, -2).addGap(8, 8, 8).addComponent(flagRemapPanel, -2, -1, -2).addGap(16, 16, 16).addComponent(flagJavadocsPanel, -2, -1, -2).addGap(16, 16, 16).addComponent(flagGenerateSourcesPanel, -2, -1, -2).addGap(16, 16, 16).addComponent(flagCompileChangesPanel, -2, -1, -2).addGap(16, 16, 16).addComponent(flagSkipHTTPSCheckPanel, -2, -1, -2).addGap(16, 16, 16).addComponent(flagSkipJavaVersionCheckPanel, -2, -1, -2).addGap(16, 16, 16).addComponent(flagDontUpdatePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 147, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(pullRequestsLabel, -2, -1, -2).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(spigotPrTextField, -2, -1, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(bukkitPrTextField, -2, -1, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(craftbukkitPrTextField, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(javaConfigurationLabel, -2, -1, -2).addComponent(overrideJavaCheckbox)).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaExecutableField, -2, 32, -2).addComponent(javaExecutableLabel).addComponent(this.javaSelectionButton, -2, 32, -2).addComponent(this.detectJavaButton, -2, 32, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jvmArgumentsField, -2, 32, -2).addComponent(jvmArgumentsLabel)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(workDirField, -2, 32, -2).addComponent(workDirLabel))).addGroup(layout.createSequentialGroup().addComponent(compilationOptionsLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.compileNoneCheckbox).addGap(26, 26, 26).addComponent(this.compileSpigotCheckbox).addGap(26, 26, 26).addComponent(this.compileCraftbukkitCheckbox)).addComponent(verticalSeparator0).addComponent(verticalSeparator1, -2, 149, -2)).addGap(0, 0, 0)));
        ArrayList<Component> order = new ArrayList<Component>();
        order.add(flagRemapPanel.getTraversableComponent());
        order.add(flagJavadocsPanel.getTraversableComponent());
        order.add(flagGenerateSourcesPanel.getTraversableComponent());
        order.add(flagCompileChangesPanel.getTraversableComponent());
        order.add(flagSkipHTTPSCheckPanel.getTraversableComponent());
        order.add(flagSkipJavaVersionCheckPanel.getTraversableComponent());
        order.add(flagDontUpdatePanel.getTraversableComponent());
        order.add(spigotPrTextField);
        order.add(bukkitPrTextField);
        order.add(craftbukkitPrTextField);
        order.add(this.compileNoneCheckbox);
        order.add(this.compileSpigotCheckbox);
        order.add(this.compileCraftbukkitCheckbox);
        order.add(overrideJavaCheckbox);
        order.add(this.javaExecutableField);
        order.add(this.detectJavaButton);
        order.add(this.javaSelectionButton);
        order.add(jvmArgumentsField);
        order.add(workDirField);
        this.setFocusTraversalPolicyProvider(true);
        this.traversalPolicy = new CustomFocusTraversalPolicy(order);
        this.setFocusTraversalPolicy(this.traversalPolicy);
    }

    private void spigotPrFieldKeyReleased(KeyEvent event) {
        JTextField field = (JTextField)event.getSource();
        if (Utils.isNumeric(field.getText()) && !field.getText().isEmpty()) {
            this.buildSettings.setSpigotPrId("SPIGOT:" + field.getText());
        } else if (Utils.isValidSpigotPR(field.getText())) {
            this.buildSettings.setSpigotPrId(field.getText());
        } else {
            this.buildSettings.setSpigotPrId("");
        }
        SwingUtils.validateSpigotPR(field);
    }

    private void craftbukkitPrFieldKeyEvent(KeyEvent event) {
        JTextField field = (JTextField)event.getSource();
        if (Utils.isNumeric(field.getText()) && !field.getText().isEmpty()) {
            this.buildSettings.setCraftbukkitPrId("CRAFTBUKKIT:" + field.getText());
        } else if (Utils.isValidCraftbukkitPR(field.getText())) {
            this.buildSettings.setCraftbukkitPrId(field.getText());
        } else {
            this.buildSettings.setCraftbukkitPrId("");
        }
        SwingUtils.validateCraftbukkitPR(field);
    }

    private void bukkitPrFieldKeyEvent(KeyEvent event) {
        JTextField field = (JTextField)event.getSource();
        if (Utils.isNumeric(field.getText()) && !field.getText().isEmpty()) {
            this.buildSettings.setBukkitPrId("BUKKIT:" + field.getText());
        } else if (Utils.isValidBukkitPR(field.getText())) {
            this.buildSettings.setBukkitPrId(field.getText());
        } else {
            this.buildSettings.setBukkitPrId("");
        }
        SwingUtils.validateBukkitPR(field);
    }

    private void compileNoneCheckboxActionPerformed(ActionEvent event) {
        boolean selected = this.compileNoneCheckbox.isSelected();
        this.buildSettings.setCompileNone(selected);
        this.compileCraftbukkitCheckbox.setEnabled(!selected);
        this.compileCraftbukkitCheckbox.setSelected(false);
        this.buildSettings.setCompileCraftbukkit(false);
        this.compileSpigotCheckbox.setEnabled(!selected);
        this.compileSpigotCheckbox.setSelected(false);
        this.buildSettings.setCompileSpigot(false);
    }

    private void compileSpigotCheckboxActionPerformed(ActionEvent event) {
        boolean selectedSpigot = this.compileSpigotCheckbox.isSelected();
        this.buildSettings.setCompileSpigot(selectedSpigot);
    }

    private void compileCraftbukkitCheckboxActionPerformed(ActionEvent event) {
        boolean selectedCraftbukkit = this.compileCraftbukkitCheckbox.isSelected();
        this.buildSettings.setCompileCraftbukkit(selectedCraftbukkit);
    }

    private void overrideJavaCheckboxActionPerformed(JCheckBox checkbox) {
        if (checkbox.isSelected()) {
            this.javaExecutableField.setEnabled(true);
            this.detectJavaButton.setEnabled(true);
            this.javaSelectionButton.setEnabled(true);
            this.buildSettings.setOverrideJavaExecutable(true);
            return;
        }
        this.javaExecutableField.setEnabled(false);
        this.detectJavaButton.setEnabled(false);
        this.javaSelectionButton.setEnabled(false);
        this.buildSettings.setOverrideJavaExecutable(false);
        this.buildData.updateJavaExecutable(this.buildSettings, false);
    }

    private void javaExecutableFieldKeyReleased(KeyEvent event) {
    }

    private void detectJavaButtonActionPerformed(ActionEvent event) {
        SelectJavaModal modal = new SelectJavaModal(this, this.buildData.getJavaInstallationManager());
        modal.setLocationRelativeTo(null);
        modal.setVisible(true);
    }

    private void selectJavaButtonActionPerformed(ActionEvent event) {
        JFileChooser chooser = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selection = chooser.getSelectedFile();
            this.javaExecutableField.setText(selection.getAbsolutePath());
            List<JavaInstallation> installations = JavaFinder.builder().checkDefaultLocations(false).addSearchDirectories(selection.getAbsoluteFile().getParentFile().getParentFile()).build().findInstallations();
            if (!installations.isEmpty()) {
                this.buildData.getJavaInstallationManager().setSelectedInstallation(installations.get(0));
            }
        }
    }

    private void jvmArgumentsFieldKeyReleased(KeyEvent event) {
        JTextField field = (JTextField)event.getSource();
        this.buildData.getJavaInstallationManager().setJvmArguments(field.getText());
    }

    private void workDirectoryFieldKeyRelease(KeyEvent event) {
        JTextField textField = (JTextField)event.getSource();
        this.buildSettings.setWorkDirectory(textField.getText());
        SwingUtils.validatePath(textField);
        if (textField.getText().isEmpty()) {
            this.panel.getSettingsPanel().getOutputDirField().setPlaceholder(Builder.CWD.toString());
        } else {
            this.panel.getSettingsPanel().getOutputDirField().setPlaceholder(textField.getText());
        }
    }

    public void setJavaExecutable(JavaInstallation executable) {
        boolean wasDisabled = false;
        if (!this.javaExecutableField.isEnabled()) {
            this.javaExecutableField.setEnabled(true);
            wasDisabled = true;
        }
        this.javaExecutableField.setText(executable.getJavaExecutable().getAbsolutePath());
        if (wasDisabled) {
            this.javaExecutableField.setEnabled(false);
        }
    }

    private static JCheckBox createCompilationOption(String text, String tooltip, ActionListener actionListener) {
        JCheckBox checkBox = new JCheckBox(text);
        checkBox.setToolTipText(tooltip);
        checkBox.setMargin(new Insets(0, 0, 0, 0));
        checkBox.addActionListener(actionListener);
        return checkBox;
    }
}

