/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.gui.data;

import com.google.common.base.Suppliers;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.jeff_media.javafinder.JavaInstallation;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spigotmc.builder.BuildInfo;
import org.spigotmc.builder.Builder;
import org.spigotmc.builder.JavaVersion;
import org.spigotmc.gui.data.BuildSettings;
import org.spigotmc.gui.data.JavaInstallationManager;
import org.spigotmc.gui.modals.MessageModal;
import org.spigotmc.utils.Utils;

public final class BuildData {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\".*?\"");
    private static final String VERSION_PATTERN = "\\b\\d+\\.[\\.\\d]*";
    private final Map<String, Supplier<CompletableFuture<BuildInfo>>> builds = new HashMap<String, Supplier<CompletableFuture<BuildInfo>>>();
    private final List<String> versions = new ArrayList<String>();
    private JavaInstallationManager javaInstallationManager;
    private String latestVersion = "unknown";

    public BuildData(Consumer<Map<String, Supplier<CompletableFuture<BuildInfo>>>> whenComplete) {
        this.retrieveBuildInfo(whenComplete);
    }

    public List<String> generatePreCompilationText(BuildSettings buildSettings) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Hey! You're about to run the following command. Does it look correct?");
        lines.add("");
        StringBuilder builder = new StringBuilder();
        for (String arg : this.buildArgs(buildSettings)) {
            builder.append(arg).append(" ");
        }
        lines.add(builder.toString());
        lines.add("");
        lines.add("If so, press the compile button already!");
        return lines;
    }

    public List<String> buildArgs(BuildSettings buildSettings) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.javaInstallationManager.getSelectedInstallation().getJavaExecutable().getAbsolutePath());
        arguments.addAll(this.javaInstallationManager.getJvmArguments());
        if (Utils.isRanFromJar()) {
            arguments.add("-jar");
            arguments.add(Utils.getFile().getPath());
        } else {
            arguments.add("-cp");
            arguments.add(System.getProperty("java.class.path"));
            arguments.add("org.spigotmc.builder.Bootstrap");
        }
        arguments.addAll(buildSettings.getArguments());
        return arguments;
    }

    public CompletableFuture<Boolean> updateJavaExecutable(BuildSettings buildSettings, boolean showModal) {
        String checkVersion = buildSettings.getVersion();
        if (checkVersion.equals("experimental")) {
            String mostRecent = this.versions.get(2);
            if (mostRecent == null || mostRecent.isEmpty()) {
                mostRecent = "latest";
            }
            checkVersion = mostRecent;
        }
        return ((CompletableFuture)this.builds.get(checkVersion).get().thenApply(info -> {
            if (buildSettings.isOverrideJavaExecutable()) {
                this.javaInstallationManager.setSelectedInstallation(this.javaInstallationManager.getSelectedInstallation());
                return true;
            }
            if (info.getJavaVersions() == null) {
                info.setJavaVersions(new int[]{JavaVersion.JAVA_7.getVersion(), JavaVersion.JAVA_8.getVersion()});
            }
            JavaVersion min = JavaVersion.getByVersion(info.getJavaVersions()[0]);
            JavaVersion max = JavaVersion.getByVersion(info.getJavaVersions()[1]);
            JavaInstallation primary = this.javaInstallationManager.getPrimaryInstallation();
            if (primary.getVersion().getClassFileMajorVersion() >= min.getVersion() && primary.getVersion().getClassFileMajorVersion() <= max.getVersion()) {
                this.javaInstallationManager.setSelectedInstallation(primary);
                return true;
            }
            JavaInstallation newInstallation = null;
            for (JavaInstallation installation : this.javaInstallationManager.getInstallations()) {
                int classFileMajorVersion = installation.getVersion().getClassFileMajorVersion();
                if (classFileMajorVersion == max.getVersion()) {
                    newInstallation = installation;
                    break;
                }
                if (classFileMajorVersion != min.getVersion()) continue;
                newInstallation = installation;
                break;
            }
            if (newInstallation == null) {
                if (showModal) {
                    String style = Utils.getFileContentsFromResource("web/reset.css");
                    String message = Utils.getFileContentsFromResource("web/insufficient_java.html");
                    message = message.replace("%STYLESHEET%", "<style>" + style + "</style>");
                    message = message.replace("%JAVA_VERSION_MIN%", min.getName());
                    message = message.replace("%JAVA_VERSION_MAX%", max.getName());
                    message = message.replace("%VERSION%", buildSettings.getVersion());
                    message = message.replace("%OPENJDK_LINK%", "https://adoptium.net/temurin/releases/");
                    message = message.replace("%AZUL_LINK%", "https://www.azul.com/downloads/#zulu");
                    message = message.replace("%ORACLE_LINK%", "https://www.oracle.com/java/technologies/downloads/");
                    MessageModal.displayError(message);
                }
                return false;
            }
            this.javaInstallationManager.setSelectedInstallation(newInstallation);
            return true;
        })).whenComplete((completed, throwable) -> {
            if (throwable != null) {
                MessageModal.displayError(Utils.getReadableStacktrace(throwable));
            }
        });
    }

    public List<String> getVersions() {
        return new ArrayList<String>(this.versions);
    }

    public JavaInstallationManager getJavaInstallationManager() {
        return this.javaInstallationManager;
    }

    private void retrieveBuildInfo(Consumer<Map<String, Supplier<CompletableFuture<BuildInfo>>>> whenComplete) {
        CompletableFuture.runAsync(() -> {
            URLConnection connection;
            try {
                connection = new URL("https://hub.spigotmc.org/versions").openConnection();
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                Matcher matcher = QUOTE_PATTERN.matcher(CharStreams.toString(reader));
                this.builds.put("experimental", null);
                this.builds.put("latest", this.futureBuildInfo("latest"));
                this.versions.add("experimental");
                this.versions.add("latest");
                while (matcher.find()) {
                    String version = matcher.group().replace('\"', ' ').replace(".json", "").trim();
                    if (!version.matches(VERSION_PATTERN)) continue;
                    this.versions.add(version);
                    this.builds.put(version, this.futureBuildInfo(version));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).whenComplete((__, throwable) -> {
            if (throwable != null) {
                MessageModal.displayError(Utils.getReadableStacktrace(throwable));
                return;
            }
            this.sortVersions(this.versions);
            this.latestVersion = this.retrieveLatestVersion();
            this.javaInstallationManager = new JavaInstallationManager();
            whenComplete.accept(this.builds);
        });
    }

    private String retrieveLatestVersion() {
        BuildInfo latestInfo = this.builds.get("latest").get().join();
        for (String version : this.versions) {
            BuildInfo info;
            if (version.equals("latest") || version.equals("experimental") || !(info = this.builds.get(version).get().join()).getName().equals(latestInfo.getName())) continue;
            return version;
        }
        return "unknown";
    }

    private Supplier<CompletableFuture<BuildInfo>> futureBuildInfo(String version) {
        return Suppliers.memoize(() -> CompletableFuture.supplyAsync(() -> {
            try {
                return new Gson().fromJson(Builder.get("https://hub.spigotmc.org/versions/" + version + ".json"), BuildInfo.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private void sortVersions(List<String> versions) {
        versions.sort((a, b) -> {
            String[] aSplit = a.split("\\.");
            String[] bSplit = b.split("\\.");
            int result = 0;
            if (aSplit.length > 1 && bSplit.length > 1) {
                int aVer = Integer.parseInt(aSplit[1]);
                int bVer = Integer.parseInt(bSplit[1]);
                result = Integer.compare(bVer, aVer);
            }
            if (result == 0 && aSplit.length > 2 && bSplit.length > 2) {
                result = bSplit[2].compareTo(aSplit[2]);
            }
            return result;
        });
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

