/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;

public abstract class ObjectIdRef
implements Ref {
    private final String name;
    private final Ref.Storage storage;
    private final ObjectId objectId;
    private final long updateIndex;

    protected ObjectIdRef(Ref.Storage st, String name, ObjectId id, long updateIndex) {
        this.name = name;
        this.storage = st;
        this.objectId = id;
        this.updateIndex = updateIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSymbolic() {
        return false;
    }

    @Override
    public Ref getLeaf() {
        return this;
    }

    @Override
    public Ref getTarget() {
        return this;
    }

    @Override
    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    public Ref.Storage getStorage() {
        return this.storage;
    }

    @Override
    public long getUpdateIndex() {
        if (this.updateIndex == -1L) {
            throw new UnsupportedOperationException();
        }
        return this.updateIndex;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Ref[");
        r.append(this.getName());
        r.append('=');
        r.append(ObjectId.toString(this.getObjectId()));
        r.append('(');
        r.append(this.updateIndex);
        r.append(")]");
        return r.toString();
    }

    public static class PeeledNonTag
    extends ObjectIdRef {
        public PeeledNonTag(Ref.Storage st, String name, ObjectId id) {
            super(st, name, id, -1L);
        }

        public PeeledNonTag(Ref.Storage st, String name, ObjectId id, long updateIndex) {
            super(st, name, id, updateIndex);
        }

        @Override
        public ObjectId getPeeledObjectId() {
            return null;
        }

        @Override
        public boolean isPeeled() {
            return true;
        }
    }

    public static class PeeledTag
    extends ObjectIdRef {
        private final ObjectId peeledObjectId;

        public PeeledTag(Ref.Storage st, String name, ObjectId id, ObjectId p) {
            super(st, name, id, -1L);
            this.peeledObjectId = p;
        }

        public PeeledTag(Ref.Storage st, String name, ObjectId id, ObjectId p, long updateIndex) {
            super(st, name, id, updateIndex);
            this.peeledObjectId = p;
        }

        @Override
        public ObjectId getPeeledObjectId() {
            return this.peeledObjectId;
        }

        @Override
        public boolean isPeeled() {
            return true;
        }
    }

    public static class Unpeeled
    extends ObjectIdRef {
        public Unpeeled(Ref.Storage st, String name, ObjectId id) {
            super(st, name, id, -1L);
        }

        public Unpeeled(Ref.Storage st, String name, ObjectId id, long updateIndex) {
            super(st, name, id, updateIndex);
        }

        @Override
        public ObjectId getPeeledObjectId() {
            return null;
        }

        @Override
        public boolean isPeeled() {
            return false;
        }
    }
}

