/*
 * Decompiled with CFR 0.152.
 */
package com.jeff_media.javafinder;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVersion
implements Comparable<JavaVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>[0-9]+)([.](?<minor>[0-9]+))?([.](?<security>[0-9]+))?(-(?<prerelease>[a-zA-Z0-9]+))?");
    private static final Pattern PRE_9_VERSION_PATTERN = Pattern.compile("1[.](?<major>[0-9]+)([.](?<minor>[0-9]+))?(_(?<security>[0-9]+)?)?(-(?<prerelease>[a-zA-Z0-9]+))?");
    private final int major;
    private final int minor;
    @Nullable
    private final String security;
    @Nullable
    private final String preRelease;
    private final List<String> javaVersionOutput;
    @NotNull
    private final String shortVersion;
    @NotNull
    private final String fullVersion;

    private JavaVersion(int major, int minor, @Nullable String security, @Nullable String preRelease, List<String> javaVersionOutput, @NotNull String shortVersion, @NotNull String fullVersion) {
        this.major = major;
        this.minor = minor;
        this.security = security;
        this.preRelease = preRelease;
        this.javaVersionOutput = javaVersionOutput;
        this.shortVersion = shortVersion;
        this.fullVersion = fullVersion;
    }

    public static JavaVersion fromJavaVersionOutput(@NotNull List<String> javaVersionOutput) {
        javaVersionOutput.removeIf(line -> line.startsWith("Picked up "));
        List<String> output = Collections.unmodifiableList(javaVersionOutput);
        String shortVersion = output.get(0).split("\"")[1];
        String fullVersion = output.get(1).split("build ")[1].split("\\)")[0];
        Pattern pattern = !fullVersion.startsWith("1.") ? VERSION_PATTERN : PRE_9_VERSION_PATTERN;
        Matcher matcher = pattern.matcher(fullVersion);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Could not parse version: " + fullVersion);
        }
        String majorStr = matcher.group("major");
        String minorStr = matcher.group("minor");
        int major = Integer.parseInt(majorStr);
        int minor = 0;
        if (minorStr != null) {
            try {
                minor = Integer.parseInt(minorStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String security = matcher.group("security");
        String preRelease = matcher.group("prerelease");
        return new JavaVersion(major, minor, security, preRelease, javaVersionOutput, shortVersion, fullVersion);
    }

    private int compareOldBeforeNew(@NotNull JavaVersion o) {
        if (this.major != o.major) {
            return Integer.compare(this.major, o.major);
        }
        if (this.minor != o.minor) {
            return Integer.compare(this.minor, o.minor);
        }
        if (this.security != null && o.security != null) {
            return this.security.compareTo(o.security);
        }
        return 0;
    }

    @Override
    public int compareTo(@NotNull JavaVersion o) {
        return -this.compareOldBeforeNew(o);
    }

    public int getClassFileMajorVersion() {
        return this.major + 44;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @Nullable
    public String getSecurity() {
        return this.security;
    }

    @Nullable
    private String getPreRelease() {
        return this.preRelease;
    }

    @NotNull
    public List<String> getJavaVersionOutput() {
        return this.javaVersionOutput;
    }

    @NotNull
    public String getShortVersion() {
        return this.shortVersion;
    }

    @NotNull
    public String getFullVersion() {
        return this.fullVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaVersion)) {
            return false;
        }
        JavaVersion other = (JavaVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        String this$security = this.getSecurity();
        String other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !this$security.equals(other$security)) {
            return false;
        }
        String this$preRelease = this.getPreRelease();
        String other$preRelease = other.getPreRelease();
        if (this$preRelease == null ? other$preRelease != null : !this$preRelease.equals(other$preRelease)) {
            return false;
        }
        List<String> this$javaVersionOutput = this.getJavaVersionOutput();
        List<String> other$javaVersionOutput = other.getJavaVersionOutput();
        if (this$javaVersionOutput == null ? other$javaVersionOutput != null : !((Object)this$javaVersionOutput).equals(other$javaVersionOutput)) {
            return false;
        }
        String this$shortVersion = this.getShortVersion();
        String other$shortVersion = other.getShortVersion();
        if (this$shortVersion == null ? other$shortVersion != null : !this$shortVersion.equals(other$shortVersion)) {
            return false;
        }
        String this$fullVersion = this.getFullVersion();
        String other$fullVersion = other.getFullVersion();
        return !(this$fullVersion == null ? other$fullVersion != null : !this$fullVersion.equals(other$fullVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        String $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : $security.hashCode());
        String $preRelease = this.getPreRelease();
        result = result * 59 + ($preRelease == null ? 43 : $preRelease.hashCode());
        List<String> $javaVersionOutput = this.getJavaVersionOutput();
        result = result * 59 + ($javaVersionOutput == null ? 43 : ((Object)$javaVersionOutput).hashCode());
        String $shortVersion = this.getShortVersion();
        result = result * 59 + ($shortVersion == null ? 43 : $shortVersion.hashCode());
        String $fullVersion = this.getFullVersion();
        result = result * 59 + ($fullVersion == null ? 43 : $fullVersion.hashCode());
        return result;
    }

    public String toString() {
        return "JavaVersion(major=" + this.getMajor() + ", minor=" + this.getMinor() + ", security=" + this.getSecurity() + ", preRelease=" + this.getPreRelease() + ", javaVersionOutput=" + this.getJavaVersionOutput() + ", shortVersion=" + this.getShortVersion() + ", fullVersion=" + this.getFullVersion() + ")";
    }
}

