/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.builder;

import java.util.HashMap;
import java.util.Map;

public enum JavaVersion {
    UNKNOWN(-1),
    JAVA_5(49),
    JAVA_6(50),
    JAVA_7(51),
    JAVA_8(52),
    JAVA_9(53),
    JAVA_10(54),
    JAVA_11(55);

    private final int version;
    private static final Map<Integer, JavaVersion> byVersion;

    private JavaVersion(int version) {
        this.version = version;
    }

    public static JavaVersion getByVersion(int version) {
        return byVersion.containsKey(version) ? byVersion.get(version) : UNKNOWN;
    }

    public static JavaVersion getCurrentVersion() {
        return JavaVersion.getByVersion((int)Float.parseFloat(System.getProperty("java.class.version")));
    }

    public static String printVersions(int[] versions) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int v : versions) {
            JavaVersion found = JavaVersion.getByVersion(v);
            sb.append(found == UNKNOWN ? Integer.valueOf(v) : found);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        return sb.toString();
    }

    public int getVersion() {
        return this.version;
    }

    static {
        byVersion = new HashMap<Integer, JavaVersion>();
        for (JavaVersion version : JavaVersion.values()) {
            byVersion.put(version.version, version);
        }
    }
}

