/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.builder;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.spigotmc.builder.BuildInfo;
import org.spigotmc.builder.JavaVersion;
import org.spigotmc.builder.VersionInfo;

public class Builder {
    public static final String LOG_FILE = "BuildTools.log.txt";
    public static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    public static final File CWD = new File(".");
    private static final boolean autocrlf = !"\n".equals(System.getProperty("line.separator"));
    private static boolean dontUpdate;
    private static boolean skipCompile;
    private static boolean generateSource;
    private static boolean generateDocs;
    private static boolean dev;
    private static String applyPatchesShell;
    private static File msysDir;

    public static void main(String[] args) throws Exception {
        File spigotServer;
        File vanillaJar;
        VersionInfo versionInfo;
        Object maxVersion;
        File maven;
        String m2Home;
        File buildData;
        File spigot;
        File craftBukkit;
        String[] split;
        if (CWD.getAbsolutePath().contains("'") || CWD.getAbsolutePath().contains("#")) {
            System.err.println("Please do not run in a path with special characters!");
            return;
        }
        String buildVersion = Builder.class.getPackage().getImplementationVersion();
        int buildNumber = -1;
        if (buildVersion != null && (split = buildVersion.split("-")).length == 4) {
            try {
                buildNumber = Integer.parseInt(split[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        System.out.println("Loading BuildTools version: " + buildVersion + " (#" + buildNumber + ")");
        System.out.println("Java Version: " + (Object)((Object)JavaVersion.getCurrentVersion()));
        OptionParser parser = new OptionParser();
        OptionSpecBuilder disableCertFlag = parser.accepts("disable-certificate-check");
        OptionSpecBuilder disableJavaCheck = parser.accepts("disable-java-check");
        OptionSpecBuilder dontUpdateFlag = parser.accepts("dont-update");
        OptionSpecBuilder skipCompileFlag = parser.accepts("skip-compile");
        OptionSpecBuilder generateSourceFlag = parser.accepts("generate-source");
        OptionSpecBuilder generateDocsFlag = parser.accepts("generate-docs");
        OptionSpecBuilder devFlag = parser.accepts("dev");
        ArgumentAcceptingOptionSpec<File> outputDir = parser.acceptsAll(Arrays.asList("o", "output-dir")).withRequiredArg().ofType(File.class).defaultsTo(CWD, (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> jenkinsVersion = parser.accepts("rev").withRequiredArg().defaultsTo("latest", (String[])new String[0]);
        OptionSet options = parser.parse(args);
        if (options.has(disableCertFlag)) {
            Builder.disableHttpsCertificateCheck();
        }
        dontUpdate = options.has(dontUpdateFlag);
        skipCompile = options.has(skipCompileFlag);
        generateSource = options.has(generateSourceFlag);
        generateDocs = options.has(generateDocsFlag);
        dev = options.has(devFlag);
        Builder.logOutput();
        try {
            Builder.runProcess(CWD, "sh", "-c", "exit");
        }
        catch (Exception ex) {
            if (IS_WINDOWS) {
                String gitVersion = "PortableGit-2.15.0-" + (System.getProperty("os.arch").endsWith("64") ? "64" : "32") + "-bit";
                msysDir = new File(gitVersion, "PortableGit");
                if (!msysDir.isDirectory()) {
                    System.out.println("*** Could not find PortableGit installation, downloading. ***");
                    String gitName = gitVersion + ".7z.exe";
                    File gitInstall = new File(gitVersion, gitName);
                    gitInstall.getParentFile().mkdirs();
                    if (!gitInstall.exists()) {
                        Builder.download("https://static.spigotmc.org/git/" + gitName, gitInstall);
                    }
                    System.out.println("Extracting downloaded git install");
                    Builder.runProcess(gitInstall.getParentFile(), gitInstall.getAbsolutePath(), "-y", "-gm2", "-nr");
                    gitInstall.delete();
                }
                System.out.println("*** Using downloaded git " + msysDir + " ***");
                System.out.println("*** Please note that this is a beta feature, so if it does not work please also try a manual install of git from https://git-for-windows.github.io/ ***");
            }
            System.out.println("You must run this jar through bash (msysgit)");
            System.exit(1);
        }
        Builder.runProcess(CWD, "git", "--version");
        try {
            Builder.runProcess(CWD, "git", "config", "--global", "--includes", "user.name");
        }
        catch (Exception ex) {
            System.out.println("Git name not set, setting it to default value.");
            Builder.runProcess(CWD, "git", "config", "--global", "user.name", "BuildTools");
        }
        try {
            Builder.runProcess(CWD, "git", "config", "--global", "--includes", "user.email");
        }
        catch (Exception ex) {
            System.out.println("Git email not set, setting it to default value.");
            Builder.runProcess(CWD, "git", "config", "--global", "user.email", "unconfigured@null.spigotmc.org");
        }
        File workDir = new File("work");
        workDir.mkdir();
        File bukkit = new File("Bukkit");
        if (!bukkit.exists()) {
            Builder.clone("https://hub.spigotmc.org/stash/scm/spigot/bukkit.git", bukkit);
        }
        if (!(craftBukkit = new File("CraftBukkit")).exists()) {
            Builder.clone("https://hub.spigotmc.org/stash/scm/spigot/craftbukkit.git", craftBukkit);
        }
        if (!(spigot = new File("Spigot")).exists()) {
            Builder.clone("https://hub.spigotmc.org/stash/scm/spigot/spigot.git", spigot);
        }
        if (!(buildData = new File("BuildData")).exists()) {
            Builder.clone("https://hub.spigotmc.org/stash/scm/spigot/builddata.git", buildData);
        }
        if (!((m2Home = System.getenv("M2_HOME")) != null && (maven = new File(m2Home)).exists() || (maven = new File("apache-maven-3.5.0")).exists())) {
            System.out.println("Maven does not exist, downloading. Please wait.");
            File mvnTemp = new File("mvn.zip");
            mvnTemp.deleteOnExit();
            Builder.download("https://static.spigotmc.org/maven/apache-maven-3.5.0-bin.zip", mvnTemp);
            Builder.unzip(mvnTemp, new File("."));
        }
        String mvn = maven.getAbsolutePath() + "/bin/mvn";
        Git bukkitGit = Git.open(bukkit);
        Git craftBukkitGit = Git.open(craftBukkit);
        Git spigotGit = Git.open(spigot);
        Git buildGit = Git.open(buildData);
        BuildInfo buildInfo = new BuildInfo("Dev Build", "Development", 0, null, new BuildInfo.Refs("master", "master", "master", "master"));
        if (!dontUpdate) {
            if (!dev) {
                String verInfo;
                String askedVersion = options.valueOf(jenkinsVersion);
                System.out.println("Attempting to build version: '" + askedVersion + "' use --rev <version> to override");
                try {
                    verInfo = Builder.get("https://hub.spigotmc.org/versions/" + askedVersion + ".json");
                }
                catch (IOException ex) {
                    System.err.println("Could not get version " + askedVersion + " does it exist? Try another version or use 'latest'");
                    ex.printStackTrace();
                    return;
                }
                System.out.println("Found version");
                System.out.println(verInfo);
                buildInfo = new Gson().fromJson(verInfo, BuildInfo.class);
                if (buildNumber != -1 && buildInfo.getToolsVersion() != -1 && buildNumber < buildInfo.getToolsVersion()) {
                    System.err.println("**** Your BuildTools is out of date and will not build the requested version. Please grab a new copy from https://www.spigotmc.org/go/buildtools-dl");
                    System.exit(1);
                }
                if (!options.has(disableJavaCheck)) {
                    if (buildInfo.getJavaVersions() == null) {
                        buildInfo.setJavaVersions(new int[]{JavaVersion.JAVA_7.getVersion(), JavaVersion.JAVA_8.getVersion()});
                    }
                    Preconditions.checkArgument(buildInfo.getJavaVersions().length == 2, "Expected only two Java versions, got %s", (Object)JavaVersion.printVersions(buildInfo.getJavaVersions()));
                    JavaVersion curVersion = JavaVersion.getCurrentVersion();
                    JavaVersion minVersion = JavaVersion.getByVersion(buildInfo.getJavaVersions()[0]);
                    maxVersion = JavaVersion.getByVersion(buildInfo.getJavaVersions()[1]);
                    if (minVersion == JavaVersion.UNKNOWN || maxVersion == JavaVersion.UNKNOWN) {
                        System.err.println("*** This BuildTools doesn't know how to use  Java versions " + JavaVersion.printVersions(buildInfo.getJavaVersions()) + ", please update");
                        System.exit(1);
                    }
                    if (curVersion.getVersion() < minVersion.getVersion() || curVersion.getVersion() > ((JavaVersion)((Object)maxVersion)).getVersion()) {
                        System.err.println("*** The version you have requested to build requires Java versions between " + JavaVersion.printVersions(buildInfo.getJavaVersions()) + ", but you are using " + (Object)((Object)curVersion));
                        System.err.println("*** Please rerun BuildTools using an appropriate Java version. For obvious reasons outdated MC versions do not support Java versions that did not exist at their release.");
                        System.exit(1);
                    }
                }
            }
            Builder.pull(buildGit, buildInfo.getRefs().getBuildData());
            Builder.pull(bukkitGit, buildInfo.getRefs().getBukkit());
            Builder.pull(craftBukkitGit, buildInfo.getRefs().getCraftBukkit());
            Builder.pull(spigotGit, buildInfo.getRefs().getSpigot());
        }
        if ((versionInfo = new Gson().fromJson(Files.toString(new File("BuildData/info.json"), Charsets.UTF_8), VersionInfo.class)) == null) {
            versionInfo = new VersionInfo("1.8", "bukkit-1.8.at", "bukkit-1.8-cl.csrg", "bukkit-1.8-members.csrg", "package.srg", null);
        }
        System.out.println("Attempting to build Minecraft with details: " + versionInfo);
        if (buildNumber != -1 && versionInfo.getToolsVersion() != -1 && buildNumber < versionInfo.getToolsVersion()) {
            System.err.println("");
            System.err.println("**** Your BuildTools is out of date and will not build the requested version. Please grab a new copy from https://www.spigotmc.org/go/buildtools-dl");
            System.exit(1);
        }
        if (!(vanillaJar = new File(workDir, "minecraft_server." + versionInfo.getMinecraftVersion() + ".jar")).exists() || !Builder.checkHash(vanillaJar, versionInfo)) {
            if (versionInfo.getServerUrl() != null) {
                Builder.download(versionInfo.getServerUrl(), vanillaJar);
            } else {
                Builder.download(String.format("https://s3.amazonaws.com/Minecraft.Download/versions/%1$s/minecraft_server.%1$s.jar", versionInfo.getMinecraftVersion()), vanillaJar);
                applyPatchesShell = System.getenv().get("SHELL");
                if (applyPatchesShell == null || applyPatchesShell.trim().isEmpty()) {
                    applyPatchesShell = "bash";
                }
            }
        }
        if (!Builder.checkHash(vanillaJar, versionInfo)) {
            System.err.println("**** Could not download clean Minecraft jar, giving up.");
            return;
        }
        Object mappings = buildGit.log().addPath("mappings/" + versionInfo.getAccessTransforms()).addPath("mappings/" + versionInfo.getClassMappings()).addPath("mappings/" + versionInfo.getMemberMappings()).addPath("mappings/" + versionInfo.getPackageMappings()).setMaxCount(1).call();
        Hasher mappingsHash = Hashing.md5().newHasher();
        maxVersion = mappings.iterator();
        while (maxVersion.hasNext()) {
            RevCommit rev = (RevCommit)maxVersion.next();
            mappingsHash.putString(rev.getName(), Charsets.UTF_8);
        }
        String mappingsVersion = mappingsHash.hash().toString().substring(24);
        File finalMappedJar = new File(workDir, "mapped." + mappingsVersion + ".jar");
        if (!finalMappedJar.exists()) {
            System.out.println("Final mapped jar: " + finalMappedJar + " does not exist, creating (please wait)!");
            File clMappedJar = new File(finalMappedJar + "-cl");
            File mMappedJar = new File(finalMappedJar + "-m");
            if (versionInfo.getClassMapCommand() == null) {
                versionInfo.setClassMapCommand("java -jar BuildData/bin/SpecialSource-2.jar map -i {0} -m {1} -o {2}");
            }
            Builder.runProcess(CWD, MessageFormat.format(versionInfo.getClassMapCommand(), vanillaJar.getPath(), "BuildData/mappings/" + versionInfo.getClassMappings(), clMappedJar.getPath()).split(" "));
            if (versionInfo.getMemberMapCommand() == null) {
                versionInfo.setMemberMapCommand("java -jar BuildData/bin/SpecialSource-2.jar map -i {0} -m {1} -o {2}");
            }
            Builder.runProcess(CWD, MessageFormat.format(versionInfo.getMemberMapCommand(), clMappedJar.getPath(), "BuildData/mappings/" + versionInfo.getMemberMappings(), mMappedJar.getPath()).split(" "));
            if (versionInfo.getFinalMapCommand() == null) {
                versionInfo.setFinalMapCommand("java -jar BuildData/bin/SpecialSource.jar --kill-lvt -i {0} --access-transformer {1} -m {2} -o {3}");
            }
            Builder.runProcess(CWD, MessageFormat.format(versionInfo.getFinalMapCommand(), mMappedJar.getPath(), "BuildData/mappings/" + versionInfo.getAccessTransforms(), "BuildData/mappings/" + versionInfo.getPackageMappings(), finalMappedJar.getPath()).split(" "));
        }
        Builder.runProcess(CWD, "sh", mvn, "install:install-file", "-Dfile=" + finalMappedJar, "-Dpackaging=jar", "-DgroupId=org.spigotmc", "-DartifactId=minecraft-server", "-Dversion=" + versionInfo.getMinecraftVersion() + "-SNAPSHOT");
        File decompileDir = new File(workDir, "decompile-" + mappingsVersion);
        if (!decompileDir.exists()) {
            decompileDir.mkdir();
            File clazzDir = new File(decompileDir, "classes");
            Builder.unzip(finalMappedJar, clazzDir, new Predicate<String>(){

                @Override
                public boolean apply(String input) {
                    return input.startsWith("net/minecraft/server");
                }
            });
            if (versionInfo.getDecompileCommand() == null) {
                versionInfo.setDecompileCommand("java -jar BuildData/bin/fernflower.jar -dgs=1 -hdc=0 -rbr=0 -asc=1 -udv=0 {0} {1}");
            }
            Builder.runProcess(CWD, MessageFormat.format(versionInfo.getDecompileCommand(), clazzDir.getPath(), decompileDir.getPath()).split(" "));
        }
        System.out.println("Applying CraftBukkit Patches");
        File nmsDir = new File(craftBukkit, "src/main/java/net");
        if (nmsDir.exists()) {
            System.out.println("Backing up NMS dir");
            FileUtils.moveDirectory(nmsDir, new File(workDir, "nms.old." + System.currentTimeMillis()));
        }
        File patchDir = new File(craftBukkit, "nms-patches");
        for (File file : patchDir.listFiles()) {
            if (!file.getName().endsWith(".patch")) continue;
            String targetFile = "net/minecraft/server/" + file.getName().replace(".patch", ".java");
            File clean = new File(decompileDir, targetFile);
            File t = new File(nmsDir.getParentFile(), targetFile);
            t.getParentFile().mkdirs();
            System.out.println("Patching with " + file.getName());
            List<String> readFile = Files.readLines(file, Charsets.UTF_8);
            boolean preludeFound = false;
            for (int i = 0; i < Math.min(3, readFile.size()); ++i) {
                if (!readFile.get(i).startsWith("+++")) continue;
                preludeFound = true;
                break;
            }
            if (!preludeFound) {
                readFile.add(0, "+++");
            }
            Patch parsedPatch = DiffUtils.parseUnifiedDiff(readFile);
            List<String> modifiedLines = DiffUtils.patch(Files.readLines(clean, Charsets.UTF_8), parsedPatch);
            BufferedWriter bw = new BufferedWriter(new FileWriter(t));
            for (String line : modifiedLines) {
                bw.write(line);
                bw.newLine();
            }
            bw.close();
        }
        File tmpNms = new File(craftBukkit, "tmp-nms");
        FileUtils.copyDirectory(nmsDir, tmpNms);
        craftBukkitGit.branchDelete().setBranchNames("patched").setForce(true).call();
        craftBukkitGit.checkout().setCreateBranch(true).setForce(true).setName("patched").call();
        craftBukkitGit.add().addFilepattern("src/main/java/net/").call();
        craftBukkitGit.commit().setMessage("CraftBukkit $ " + new Date()).call();
        craftBukkitGit.checkout().setName(buildInfo.getRefs().getCraftBukkit()).call();
        FileUtils.moveDirectory(tmpNms, nmsDir);
        File spigotApi = new File(spigot, "Bukkit");
        if (!spigotApi.exists()) {
            Builder.clone("file://" + bukkit.getAbsolutePath(), spigotApi);
        }
        if (!(spigotServer = new File(spigot, "CraftBukkit")).exists()) {
            Builder.clone("file://" + craftBukkit.getAbsolutePath(), spigotServer);
        }
        if (!skipCompile) {
            System.out.println("Compiling Bukkit");
            Builder.runProcess(bukkit, "sh", mvn, "clean", "install");
            if (generateDocs) {
                Builder.runProcess(bukkit, "sh", mvn, "javadoc:jar");
            }
            if (generateSource) {
                Builder.runProcess(bukkit, "sh", mvn, "source:jar");
            }
            System.out.println("Compiling CraftBukkit");
            Builder.runProcess(craftBukkit, "sh", mvn, "clean", "install");
        }
        try {
            Builder.runProcess(spigot, applyPatchesShell, "applyPatches.sh");
            System.out.println("*** Spigot patches applied!");
            if (!skipCompile) {
                System.out.println("Compiling Spigot & Spigot-API");
                Builder.runProcess(spigot, "sh", mvn, "clean", "install");
            }
        }
        catch (Exception ex) {
            System.err.println("Error compiling Spigot. Please check the wiki for FAQs.");
            System.err.println("If this does not resolve your issue then please pastebin the entire BuildTools.log.txt file when seeking support.");
            ex.printStackTrace();
            System.exit(1);
        }
        for (int i = 0; i < 35; ++i) {
            System.out.println(" ");
        }
        if (!skipCompile) {
            System.out.println("Success! Everything compiled successfully. Copying final .jar files now.");
            Builder.copyJar("CraftBukkit/target", "craftbukkit", new File((File)outputDir.value(options), "craftbukkit-" + versionInfo.getMinecraftVersion() + ".jar"));
            Builder.copyJar("Spigot/Spigot-Server/target", "spigot", new File((File)outputDir.value(options), "spigot-" + versionInfo.getMinecraftVersion() + ".jar"));
        }
    }

    private static boolean checkHash(File vanillaJar, VersionInfo versionInfo) throws IOException {
        String hash = Files.hash(vanillaJar, Hashing.md5()).toString();
        if (!dev && versionInfo.getMinecraftHash() != null && !hash.equals(versionInfo.getMinecraftHash())) {
            System.err.println("**** Warning, Minecraft jar hash of " + hash + " does not match stored hash of " + versionInfo.getMinecraftHash());
            return false;
        }
        System.out.println("Found good Minecraft hash (" + hash + ")");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String get(String url) throws IOException {
        URLConnection con = new URL(url).openConnection();
        con.setConnectTimeout(5000);
        con.setReadTimeout(5000);
        InputStreamReader r = null;
        try {
            r = new InputStreamReader(con.getInputStream());
            String string = CharStreams.toString(r);
            return string;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    public static void copyJar(String path, final String jarPrefix, File outJar) throws Exception {
        File[] files = new File(path).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(jarPrefix) && name.endsWith(".jar");
            }
        });
        if (!outJar.getParentFile().isDirectory()) {
            outJar.getParentFile().mkdirs();
        }
        for (File file : files) {
            System.out.println("Copying " + file.getName() + " to " + outJar.getAbsolutePath());
            Files.copy(file, outJar);
            System.out.println("  - Saved as " + outJar);
        }
    }

    public static void pull(Git repo, String ref) throws Exception {
        System.out.println("Pulling updates for " + repo.getRepository().getDirectory());
        repo.reset().setRef("origin/master").setMode(ResetCommand.ResetType.HARD).call();
        repo.fetch().call();
        System.out.println("Successfully fetched updates!");
        repo.reset().setRef(ref).setMode(ResetCommand.ResetType.HARD).call();
        if (ref.equals("master")) {
            repo.reset().setRef("origin/master").setMode(ResetCommand.ResetType.HARD).call();
        }
        System.out.println("Checked out: " + ref);
    }

    public static int runProcess(File workDir, String ... command) throws Exception {
        if (msysDir != null) {
            if ("bash".equals(command[0])) {
                command[0] = "git-bash";
            }
            String[] shim = new String[]{"cmd.exe", "/C"};
            command = ObjectArrays.concat(shim, command, String.class);
        }
        return Builder.runProcess0(workDir, command);
    }

    private static int runProcess0(File workDir, String ... command) throws Exception {
        Preconditions.checkArgument(workDir != null, "workDir");
        Preconditions.checkArgument(command != null && command.length > 0, "Invalid command");
        if (command[0].equals("java")) {
            command[0] = System.getProperty("java.home") + "/bin/" + command[0];
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.directory(workDir);
        pb.environment().put("JAVA_HOME", System.getProperty("java.home"));
        pb.environment().remove("M2_HOME");
        if (!pb.environment().containsKey("MAVEN_OPTS")) {
            pb.environment().put("MAVEN_OPTS", "-Xmx1024M");
        }
        if (!pb.environment().containsKey("_JAVA_OPTIONS")) {
            String javaOptions = "-Djdk.net.URLClassPath.disableClassPathURLCheck=true";
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!arg.startsWith("-Xmx")) continue;
                javaOptions = javaOptions + " " + arg;
            }
            pb.environment().put("_JAVA_OPTIONS", javaOptions);
        }
        if (msysDir != null) {
            String pathEnv = null;
            for (String key : pb.environment().keySet()) {
                if (!key.equalsIgnoreCase("path")) continue;
                pathEnv = key;
            }
            if (pathEnv == null) {
                throw new IllegalStateException("Could not find path variable!");
            }
            String path = pb.environment().get(pathEnv);
            path = path + ";" + msysDir.getAbsolutePath();
            path = path + ";" + new File(msysDir, "bin").getAbsolutePath();
            pb.environment().put(pathEnv, path);
        }
        Process ps = pb.start();
        new Thread((Runnable)new StreamRedirector(ps.getInputStream(), System.out), "System.out redirector").start();
        new Thread((Runnable)new StreamRedirector(ps.getErrorStream(), System.err), "System.err redirector").start();
        int status = ps.waitFor();
        if (status != 0) {
            throw new RuntimeException("Error running command, return status !=0: " + Arrays.toString(command));
        }
        return status;
    }

    public static void unzip(File zipFile, File targetFolder) throws IOException {
        Builder.unzip(zipFile, targetFolder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File targetFolder, Predicate<String> filter) throws IOException {
        targetFolder.mkdir();
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (filter != null && !filter.apply(entry.getName())) continue;
                File outFile = new File(targetFolder, entry.getName());
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                if (outFile.getParentFile() != null) {
                    outFile.getParentFile().mkdirs();
                }
                InputStream is = zip.getInputStream(entry);
                FileOutputStream os = new FileOutputStream(outFile);
                try {
                    ByteStreams.copy(is, os);
                }
                finally {
                    is.close();
                    ((OutputStream)os).close();
                }
                System.out.println("Extracted: " + outFile);
            }
        }
        finally {
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clone(String url, File target) throws GitAPIException, IOException {
        System.out.println("Starting clone of " + url + " to " + target);
        Git result = Git.cloneRepository().setURI(url).setDirectory(target).call();
        try {
            StoredConfig config = result.getRepository().getConfig();
            config.setBoolean("core", null, "autocrlf", autocrlf);
            config.save();
            System.out.println("Cloned git repository " + url + " to " + target.getAbsolutePath() + ". Current HEAD: " + Builder.commitHash(result));
        }
        finally {
            result.close();
        }
    }

    public static String commitHash(Git repo) throws GitAPIException {
        return ((RevCommit)Iterables.getOnlyElement(repo.log().setMaxCount(1).call())).getName();
    }

    public static File download(String url, File target) throws IOException {
        System.out.println("Starting download of " + url);
        byte[] bytes = Resources.toByteArray(new URL(url));
        System.out.println("Downloaded file: " + target + " with md5: " + Hashing.md5().hashBytes(bytes).toString());
        Files.write(bytes, target);
        return target;
    }

    public static void disableHttpsCertificateCheck() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Failed to disable https certificate check");
            ex.printStackTrace(System.err);
        }
        catch (KeyManagementException ex) {
            System.out.println("Failed to disable https certificate check");
            ex.printStackTrace(System.err);
        }
    }

    public static void logOutput() {
        try {
            final BufferedOutputStream logOut = new BufferedOutputStream(new FileOutputStream(LOG_FILE));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
                    System.setErr(new PrintStream(new FileOutputStream(FileDescriptor.err)));
                    try {
                        logOut.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            System.setOut(new PrintStream(new TeeOutputStream(System.out, logOut)));
            System.setErr(new PrintStream(new TeeOutputStream(System.err, logOut)));
        }
        catch (FileNotFoundException ex) {
            System.err.println("Failed to create log file: BuildTools.log.txt");
        }
    }

    static {
        applyPatchesShell = "sh";
    }

    private static class StreamRedirector
    implements Runnable {
        private final InputStream in;
        private final PrintStream out;

        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.out.println(line);
                }
            }
            catch (IOException ex) {
                throw Throwables.propagate(ex);
            }
        }

        public StreamRedirector(InputStream in, PrintStream out) {
            this.in = in;
            this.out = out;
        }
    }
}

