/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import org.eclipse.jgit.lib.Config;

public class ReftableConfig {
    private int refBlockSize = 4096;
    private int logBlockSize;
    private int restartInterval;
    private int maxIndexLevels;
    private boolean alignBlocks = true;
    private boolean indexObjects = true;

    public ReftableConfig() {
    }

    public ReftableConfig(Config cfg) {
        this.fromConfig(cfg);
    }

    public int getRefBlockSize() {
        return this.refBlockSize;
    }

    public int getLogBlockSize() {
        return this.logBlockSize;
    }

    public int getRestartInterval() {
        return this.restartInterval;
    }

    public int getMaxIndexLevels() {
        return this.maxIndexLevels;
    }

    public boolean isAlignBlocks() {
        return this.alignBlocks;
    }

    public boolean isIndexObjects() {
        return this.indexObjects;
    }

    public void fromConfig(Config rc) {
        this.refBlockSize = rc.getInt("reftable", "blockSize", this.refBlockSize);
        this.logBlockSize = rc.getInt("reftable", "logBlockSize", this.logBlockSize);
        this.restartInterval = rc.getInt("reftable", "restartInterval", this.restartInterval);
        this.maxIndexLevels = rc.getInt("reftable", "indexLevels", this.maxIndexLevels);
        this.alignBlocks = rc.getBoolean("reftable", "alignBlocks", this.alignBlocks);
        this.indexObjects = rc.getBoolean("reftable", "indexObjects", this.indexObjects);
    }
}

