/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.Buffer;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorImpl;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.LongArray;
import com.googlecode.javaewah.NonEmptyVirtualStorage;
import com.googlecode.javaewah.RunningLengthWord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;

public final class EWAHCompressedBitmap
implements BitmapStorage,
Externalizable,
Cloneable,
Iterable<Integer> {
    final Buffer buffer;
    private RunningLengthWord rlw = null;
    private int sizeInBits = 0;

    public EWAHCompressedBitmap() {
        this(new LongArray());
    }

    public EWAHCompressedBitmap(int bufferSize) {
        this(new LongArray(bufferSize));
    }

    private EWAHCompressedBitmap(Buffer buffer) {
        this.buffer = buffer;
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    @Override
    public void addWord(long newData) {
        this.addWord(newData, 64);
    }

    public void addWord(long newData, int bitsThatMatter) {
        this.sizeInBits += bitsThatMatter;
        if (newData == 0L) {
            this.insertEmptyWord(false);
        } else if (newData == -1L) {
            this.insertEmptyWord(true);
        } else {
            this.insertLiteralWord(newData);
        }
    }

    private void insertEmptyWord(boolean v) {
        boolean noLiteralWords = this.rlw.getNumberOfLiteralWords() == 0;
        long runningLength = this.rlw.getRunningLength();
        if (noLiteralWords && runningLength == 0L) {
            this.rlw.setRunningBit(v);
        }
        if (noLiteralWords && this.rlw.getRunningBit() == v && runningLength < 0xFFFFFFFFL) {
            this.rlw.setRunningLength(runningLength + 1L);
            return;
        }
        this.buffer.push_back(0L);
        this.rlw.position = this.buffer.sizeInWords() - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1L);
    }

    private void insertLiteralWord(long newData) {
        int numberSoFar = this.rlw.getNumberOfLiteralWords();
        if (numberSoFar >= Integer.MAX_VALUE) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            this.rlw.setNumberOfLiteralWords(1L);
            this.buffer.push_back(newData);
        } else {
            this.rlw.setNumberOfLiteralWords(numberSoFar + 1);
            this.buffer.push_back(newData);
        }
    }

    @Override
    public void addStreamOfLiteralWords(Buffer buffer, int start, int number) {
        int leftOverNumber = number;
        while (leftOverNumber > 0) {
            int numberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatWeCanAdd = leftOverNumber < Integer.MAX_VALUE - numberOfLiteralWords ? leftOverNumber : Integer.MAX_VALUE - numberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(numberOfLiteralWords + whatWeCanAdd);
            this.buffer.push_back(buffer, start, whatWeCanAdd);
            this.sizeInBits += whatWeCanAdd * 64;
            if ((leftOverNumber -= whatWeCanAdd) <= 0) continue;
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (number == 0L) {
            return;
        }
        this.sizeInBits += (int)(number * 64L);
        this.fastaddStreamOfEmptyWords(v, number);
    }

    @Override
    public void addStreamOfNegatedLiteralWords(Buffer buffer, int start, int number) {
        int leftOverNumber = number;
        while (leftOverNumber > 0) {
            int numberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatWeCanAdd = leftOverNumber < Integer.MAX_VALUE - numberOfLiteralWords ? leftOverNumber : Integer.MAX_VALUE - numberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(numberOfLiteralWords + whatWeCanAdd);
            this.buffer.negative_push_back(buffer, start, whatWeCanAdd);
            this.sizeInBits += whatWeCanAdd * 64;
            if ((leftOverNumber -= whatWeCanAdd) <= 0) continue;
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
        }
    }

    public EWAHCompressedBitmap and(EWAHCompressedBitmap a) {
        int size = this.buffer.sizeInWords() > a.buffer.sizeInWords() ? this.buffer.sizeInWords() : a.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.andToContainer(a, container);
        return container;
    }

    public void andToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        container.clear();
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    long index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public EWAHCompressedBitmap andNot(EWAHCompressedBitmap a) {
        int size = this.buffer.sizeInWords() > a.buffer.sizeInWords() ? this.buffer.sizeInWords() : a.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.andNotToContainer(a, container);
        return container;
    }

    public void andNotToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        IteratingBufferedRunningLengthWord remaining;
        container.clear();
        EWAHIterator i = this.getEWAHIterator();
        EWAHIterator j = a.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                long index;
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else if (i_is_prey) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                } else {
                    index = prey.dischargeNegated(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & (rlwj.getLiteralWordAt(k) ^ 0xFFFFFFFFFFFFFFFFL));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        }
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator i = this.getEWAHIterator();
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter += (int)(64L * localrlw.getRunningLength());
            }
            int numberOfLiteralWords = localrlw.getNumberOfLiteralWords();
            int literalWords = i.literalWords();
            for (int j = 0; j < numberOfLiteralWords; ++j) {
                counter += Long.bitCount(i.buffer().getWord(literalWords + j));
            }
        }
        return counter;
    }

    @Override
    public void clear() {
        this.sizeInBits = 0;
        this.buffer.clear();
        this.rlw.position = 0;
    }

    public EWAHCompressedBitmap clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap clone = new EWAHCompressedBitmap(this.buffer.clone());
        clone.sizeInBits = this.sizeInBits;
        clone.rlw = new RunningLengthWord(clone.buffer, this.rlw.position);
        return clone;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeInBits);
        int siw = this.buffer.sizeInWords();
        out.writeInt(siw);
        for (int i = 0; i < siw; ++i) {
            out.writeLong(this.buffer.getWord(i));
        }
        out.writeInt(this.rlw.position);
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeInBits = in.readInt();
        int sizeInWords = in.readInt();
        this.buffer.clear();
        this.buffer.removeLastWord();
        this.buffer.ensureCapacity(sizeInWords);
        for (int i = 0; i < sizeInWords; ++i) {
            this.buffer.push_back(in.readLong());
        }
        this.rlw = new RunningLengthWord(this.buffer, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap) {
            try {
                this.xorToContainer((EWAHCompressedBitmap)o, new NonEmptyVirtualStorage());
                return true;
            }
            catch (NonEmptyVirtualStorage.NonEmptyException e) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, long number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
        }
        long runLen = this.rlw.getRunningLength();
        long whatWeCanAdd = number < 0xFFFFFFFFL - runLen ? number : 0xFFFFFFFFL - runLen;
        this.rlw.setRunningLength(runLen + whatWeCanAdd);
        number -= whatWeCanAdd;
        while (number >= 0xFFFFFFFFL) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.buffer.push_back(0L);
            this.rlw.position = this.buffer.sizeInWords() - 1;
            if (v) {
                this.rlw.setRunningBit(true);
            }
            this.rlw.setRunningLength(number);
        }
    }

    public EWAHIterator getEWAHIterator() {
        return new EWAHIterator(this.buffer);
    }

    public int hashCode() {
        int karprabin = 0;
        int B = -1640531535;
        EWAHIterator i = this.getEWAHIterator();
        while (i.hasNext()) {
            i.next();
            if (i.rlw.getRunningBit()) {
                long rl = i.rlw.getRunningLength();
                karprabin += (int)(-1640531535L * (rl & 0xFFFFFFFFFFFFFFFFL));
                karprabin += (int)(-1640531535L * (rl >>> 32 & 0xFFFFFFFFFFFFFFFFL));
            }
            int nlw = i.rlw.getNumberOfLiteralWords();
            int lw = i.literalWords();
            for (int k = 0; k < nlw; ++k) {
                long W = this.buffer.getWord(lw + k);
                karprabin = (int)((long)karprabin + -1640531535L * (W & 0xFFFFFFFFFFFFFFFFL));
                karprabin = (int)((long)karprabin + -1640531535L * (W >>> 32 & 0xFFFFFFFFFFFFFFFFL));
            }
        }
        return karprabin;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl(this.getEWAHIterator());
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return this.under.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    public EWAHCompressedBitmap or(EWAHCompressedBitmap a) {
        int size = this.buffer.sizeInWords() + a.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.orToContainer(a, container);
        return container;
    }

    public void orToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        container.clear();
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                } else {
                    long index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                }
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) | rlwj.getLiteralWordAt(k));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public boolean set(int i) {
        return this.set(i, true);
    }

    private boolean set(int i, boolean value) {
        if (i > 0x7FFFFFBF || i < 0) {
            throw new IndexOutOfBoundsException("Position should be between 0 and 2147483583");
        }
        if (i < this.sizeInBits) {
            this.locateAndSet(i, value);
        } else {
            this.extendAndSet(i, value);
        }
        return true;
    }

    private void extendAndSet(int i, boolean value) {
        int dist = this.distanceInWords(i);
        this.sizeInBits = i + 1;
        if (value) {
            if (dist > 0) {
                if (this.rlw.getNumberOfLiteralWords() > 0 && this.buffer.getLastWord() == 0L) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(false);
                }
                if (dist > 1) {
                    this.fastaddStreamOfEmptyWords(false, dist - 1);
                }
                this.insertLiteralWord(1L << i % 64);
                return;
            }
            if (this.rlw.getNumberOfLiteralWords() == 0) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                this.insertLiteralWord(1L << i % 64);
                return;
            }
            this.buffer.orLastWord(1L << i % 64);
            if (this.buffer.getLastWord() == -1L) {
                this.buffer.removeLastWord();
                this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                this.insertEmptyWord(true);
            }
        } else if (dist > 0) {
            this.fastaddStreamOfEmptyWords(false, dist);
        }
    }

    private void locateAndSet(int i, boolean value) {
        long lw;
        int nbits = 0;
        int siw = this.buffer.sizeInWords();
        for (int pos = 0; pos < siw; pos += (int)(lw + 1L)) {
            long rl = RunningLengthWord.getRunningLength(this.buffer, pos);
            boolean rb = RunningLengthWord.getRunningBit(this.buffer, pos);
            lw = RunningLengthWord.getNumberOfLiteralWords(this.buffer, pos);
            long rbits = rl * 64L;
            if ((long)i < (long)nbits + rbits) {
                this.setInRunningLength(value, i, nbits, pos, rl, rb, lw);
                return;
            }
            long lbits = lw * 64L;
            if ((long)i < (long)(nbits += (int)rbits) + lbits) {
                this.setInLiteralWords(value, i, nbits, pos, rl, rb, lw);
                return;
            }
            nbits += (int)lbits;
        }
    }

    private void setInRunningLength(boolean value, int i, int nbits, int pos, long rl, boolean rb, long lw) {
        if (value != rb) {
            int wordPosition = (i - nbits) / 64 + 1;
            int addedWords = (long)wordPosition == rl ? 1 : 2;
            this.buffer.expand(pos + 1, addedWords);
            long mask = 1L << i % 64;
            this.buffer.setWord(pos + 1, value ? mask : mask ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.rlw.position >= pos + 1) {
                this.rlw.position += addedWords;
            }
            if (addedWords == 1) {
                this.setRLWInfo(pos, rb, rl - 1L, lw + 1L);
            } else {
                this.setRLWInfo(pos, rb, wordPosition - 1, 1L);
                this.setRLWInfo(pos + 2, rb, rl - (long)wordPosition, lw);
                if (this.rlw.position == pos) {
                    this.rlw.position += 2;
                }
            }
        }
    }

    private void setInLiteralWords(boolean value, int i, int nbits, int pos, long rl, boolean rb, long lw) {
        long emptyWord;
        int wordPosition = (i - nbits) / 64 + 1;
        long mask = 1L << i % 64;
        if (value) {
            this.buffer.orWord(pos + wordPosition, mask);
        } else {
            this.buffer.andWord(pos + wordPosition, mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
        long l = emptyWord = value ? -1L : 0L;
        if (this.buffer.getWord(pos + wordPosition) == emptyWord) {
            boolean canMergeInCurrentRLW = this.mergeLiteralWordInCurrentRunningLength(value, rb, rl, wordPosition);
            boolean canMergeInNextRLW = this.mergeLiteralWordInNextRunningLength(value, lw, pos, wordPosition);
            if (canMergeInCurrentRLW && canMergeInNextRLW) {
                long nextRl = RunningLengthWord.getRunningLength(this.buffer, pos + 2);
                long nextLw = RunningLengthWord.getNumberOfLiteralWords(this.buffer, pos + 2);
                this.buffer.collapse(pos, 2);
                this.setRLWInfo(pos, value, rl + 1L + nextRl, nextLw);
                if (this.rlw.position >= pos + 2) {
                    this.rlw.position -= 2;
                }
            } else if (canMergeInCurrentRLW) {
                this.buffer.collapse(pos + 1, 1);
                this.setRLWInfo(pos, value, rl + 1L, lw - 1L);
                if (this.rlw.position >= pos + 2) {
                    --this.rlw.position;
                }
            } else if (canMergeInNextRLW) {
                int nextRLWPos = (int)((long)pos + lw + 1L);
                long nextRl = RunningLengthWord.getRunningLength(this.buffer, nextRLWPos);
                long nextLw = RunningLengthWord.getNumberOfLiteralWords(this.buffer, nextRLWPos);
                this.buffer.collapse(pos + wordPosition, 1);
                this.setRLWInfo(pos, rb, rl, lw - 1L);
                this.setRLWInfo(pos + wordPosition, value, nextRl + 1L, nextLw);
                if (this.rlw.position >= nextRLWPos) {
                    this.rlw.position = (int)((long)this.rlw.position - (lw + 1L - (long)wordPosition));
                }
            } else {
                this.setRLWInfo(pos, rb, rl, wordPosition - 1);
                this.setRLWInfo(pos + wordPosition, value, 1L, lw - (long)wordPosition);
                if (this.rlw.position == pos) {
                    this.rlw.position += wordPosition;
                }
            }
        }
    }

    private boolean mergeLiteralWordInCurrentRunningLength(boolean value, boolean rb, long rl, int wordPosition) {
        return (value == rb || rl == 0L) && wordPosition == 1;
    }

    private boolean mergeLiteralWordInNextRunningLength(boolean value, long lw, int pos, int wordPosition) {
        int nextRLWPos = (int)((long)pos + lw + 1L);
        if (lw == (long)wordPosition && nextRLWPos < this.buffer.sizeInWords()) {
            long nextRl = RunningLengthWord.getRunningLength(this.buffer, nextRLWPos);
            boolean nextRb = RunningLengthWord.getRunningBit(this.buffer, nextRLWPos);
            return value == nextRb || nextRl == 0L;
        }
        return false;
    }

    private void setRLWInfo(int pos, boolean rb, long rl, long lw) {
        RunningLengthWord.setRunningBit(this.buffer, pos, rb);
        RunningLengthWord.setRunningLength(this.buffer, pos, rl);
        RunningLengthWord.setNumberOfLiteralWords(this.buffer, pos, lw);
    }

    @Override
    public void setSizeInBitsWithinLastWord(int size) {
        if ((size + 64 - 1) / 64 > (this.sizeInBits + 64 - 1) / 64) {
            this.setSizeInBits(size, false);
            return;
        }
        if ((size + 64 - 1) / 64 != (this.sizeInBits + 64 - 1) / 64) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInBits(int,boolean).");
        }
        this.sizeInBits = size;
        int usedBitsInLast = this.sizeInBits % 64;
        if (usedBitsInLast == 0) {
            return;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            if (this.rlw.getRunningLength() > 0L) {
                this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                long word = this.rlw.getRunningBit() ? -1L >>> 64 - usedBitsInLast : 0L;
                this.insertLiteralWord(word);
            }
            return;
        }
        this.buffer.andLastWord(-1L >>> 64 - usedBitsInLast);
    }

    public boolean setSizeInBits(int size, boolean defaultValue) {
        if (size <= this.sizeInBits) {
            return false;
        }
        if (this.sizeInBits % 64 != 0) {
            if (!defaultValue) {
                if (this.rlw.getNumberOfLiteralWords() > 0) {
                    int bitsToAdd = size - this.sizeInBits;
                    int usedBitsInLast = this.sizeInBits % 64;
                    int freeBitsInLast = 64 - usedBitsInLast;
                    if (this.buffer.getLastWord() == 0L) {
                        this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                        this.buffer.removeLastWord();
                        this.sizeInBits -= usedBitsInLast;
                    } else if (usedBitsInLast > 0) {
                        this.sizeInBits += Math.min(bitsToAdd, freeBitsInLast);
                    }
                }
            } else {
                if (this.rlw.getNumberOfLiteralWords() == 0) {
                    this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
                    this.insertLiteralWord(0L);
                }
                int maskWidth = Math.min(64 - this.sizeInBits % 64, size - this.sizeInBits);
                int maskShift = this.sizeInBits % 64;
                long mask = -1L >>> 64 - maskWidth << maskShift;
                this.buffer.orLastWord(mask);
                if (this.buffer.getLastWord() == -1L) {
                    this.buffer.removeLastWord();
                    this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
                    this.insertEmptyWord(true);
                }
                this.sizeInBits += maskWidth;
            }
        }
        this.addStreamOfEmptyWords(defaultValue, size / 64 - this.sizeInBits / 64);
        if (this.sizeInBits < size) {
            int dist = this.distanceInWords(size - 1);
            if (dist > 0) {
                this.insertLiteralWord(0L);
            }
            if (defaultValue) {
                int maskWidth = size - this.sizeInBits;
                int maskShift = this.sizeInBits % 64;
                long mask = -1L >>> 64 - maskWidth << maskShift;
                this.buffer.orLastWord(mask);
            }
            this.sizeInBits = size;
        }
        return true;
    }

    private int distanceInWords(int i) {
        return (i + 64) / 64 - (this.sizeInBits + 64 - 1) / 64;
    }

    public int sizeInBits() {
        return this.sizeInBits;
    }

    public int sizeInBytes() {
        return this.buffer.sizeInWords() * 8;
    }

    public String toString() {
        StringBuilder answer = new StringBuilder();
        IntIterator i = this.intIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void trim() {
        this.buffer.trim();
    }

    public EWAHCompressedBitmap xor(EWAHCompressedBitmap a) {
        int size = this.buffer.sizeInWords() + a.buffer.sizeInWords();
        EWAHCompressedBitmap container = new EWAHCompressedBitmap(size);
        this.xorToContainer(a, container);
        return container;
    }

    public void xorToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        container.clear();
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord predator = i_is_prey ? rlwj : rlwi;
                long index = !predator.getRunningBit() ? prey.discharge(container, predator.getRunningLength()) : prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(predator.getRunningBit(), predator.getRunningLength() - index);
                predator.discardRunningWords();
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardLiteralWords(nbre_literal);
            rlwj.discardLiteralWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBitsWithinLastWord(Math.max(this.sizeInBits(), a.sizeInBits()));
    }
}

