/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.util.RawParseUtils;

public class HunkHeader {
    final FileHeader file;
    final int startOffset;
    int endOffset;
    private final OldImage old;
    int newStartLine;
    int newLineCount;
    int nContext;
    private EditList editList;

    HunkHeader(final FileHeader fh, int offset) {
        this(fh, offset, new OldImage(){});
    }

    HunkHeader(FileHeader fh, int offset, OldImage oi) {
        this.file = fh;
        this.startOffset = offset;
        this.old = oi;
    }

    HunkHeader(FileHeader fh, EditList editList) {
        this(fh, fh.buf.length);
        this.editList = editList;
        this.endOffset = this.startOffset;
        this.nContext = 0;
        if (editList.isEmpty()) {
            this.newStartLine = 0;
            this.newLineCount = 0;
        } else {
            this.newStartLine = ((Edit)editList.get(0)).getBeginB();
            Edit last = (Edit)editList.get(editList.size() - 1);
            this.newLineCount = last.getEndB() - this.newStartLine;
        }
    }

    public FileHeader getFileHeader() {
        return this.file;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public OldImage getOldImage() {
        return this.old;
    }

    public int getNewStartLine() {
        return this.newStartLine;
    }

    public int getNewLineCount() {
        return this.newLineCount;
    }

    public EditList toEditList() {
        if (this.editList == null) {
            this.editList = new EditList();
            byte[] buf = this.file.buf;
            int c = RawParseUtils.nextLF(buf, this.startOffset);
            int oLine = this.old.startLine;
            int nLine = this.newStartLine;
            Edit in = null;
            block6: while (c < this.endOffset) {
                switch (buf[c]) {
                    case 10: 
                    case 32: {
                        in = null;
                        ++oLine;
                        ++nLine;
                        break;
                    }
                    case 45: {
                        if (in == null) {
                            in = new Edit(oLine - 1, nLine - 1);
                            this.editList.add(in);
                        }
                        ++oLine;
                        in.extendA();
                        break;
                    }
                    case 43: {
                        if (in == null) {
                            in = new Edit(oLine - 1, nLine - 1);
                            this.editList.add(in);
                        }
                        ++nLine;
                        in.extendB();
                        break;
                    }
                    case 92: {
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                c = RawParseUtils.nextLF(buf, c);
            }
        }
        return this.editList;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("HunkHeader[");
        buf.append(this.getOldImage().getStartLine());
        buf.append(',');
        buf.append(this.getOldImage().getLineCount());
        buf.append("->");
        buf.append(this.getNewStartLine()).append(',').append(this.getNewLineCount());
        buf.append(']');
        return buf.toString();
    }

    public static abstract class OldImage {
        int startLine;
        int lineCount;

        public int getStartLine() {
            return this.startLine;
        }

        public int getLineCount() {
            return this.lineCount;
        }
    }
}

