/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.lib.IndexDiff;

public class Status {
    private final IndexDiff diff;
    private final boolean clean;
    private final boolean hasUncommittedChanges;

    public Status(IndexDiff diff) {
        this.diff = diff;
        this.hasUncommittedChanges = !diff.getAdded().isEmpty() || !diff.getChanged().isEmpty() || !diff.getRemoved().isEmpty() || !diff.getMissing().isEmpty() || !diff.getModified().isEmpty() || !diff.getConflicting().isEmpty();
        this.clean = !this.hasUncommittedChanges && diff.getUntracked().isEmpty();
    }

    public boolean hasUncommittedChanges() {
        return this.hasUncommittedChanges;
    }

    public Set<String> getUncommittedChanges() {
        HashSet<String> uncommittedChanges = new HashSet<String>();
        uncommittedChanges.addAll(this.diff.getAdded());
        uncommittedChanges.addAll(this.diff.getChanged());
        uncommittedChanges.addAll(this.diff.getRemoved());
        uncommittedChanges.addAll(this.diff.getMissing());
        uncommittedChanges.addAll(this.diff.getModified());
        uncommittedChanges.addAll(this.diff.getConflicting());
        return uncommittedChanges;
    }
}

