/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

abstract class AbstractRevQueue
extends Generator {
    static final AbstractRevQueue EMPTY_QUEUE = new AlwaysEmptyQueue();
    int outputType;

    AbstractRevQueue(boolean firstParent) {
        super(firstParent);
    }

    public abstract void add(RevCommit var1);

    @Override
    public abstract RevCommit next();

    abstract boolean everbodyHasFlag(int var1);

    abstract boolean anybodyHasFlag(int var1);

    @Override
    int outputType() {
        return this.outputType;
    }

    protected static void describe(StringBuilder s, RevCommit c) {
        s.append(c.toString());
        s.append('\n');
    }

    private static class AlwaysEmptyQueue
    extends AbstractRevQueue {
        private AlwaysEmptyQueue() {
            super(false);
        }

        @Override
        public void add(RevCommit c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RevCommit next() {
            return null;
        }

        @Override
        boolean anybodyHasFlag(int f) {
            return false;
        }

        @Override
        boolean everbodyHasFlag(int f) {
            return true;
        }
    }
}

