/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class LsRefsV2Request {
    private final List<String> refPrefixes;
    private final boolean symrefs;
    private final boolean peel;
    private final String agent;
    private final List<String> serverOptions;

    private LsRefsV2Request(List<String> refPrefixes, boolean symrefs, boolean peel, String agent, List<String> serverOptions) {
        this.refPrefixes = refPrefixes;
        this.symrefs = symrefs;
        this.peel = peel;
        this.agent = agent;
        this.serverOptions = Objects.requireNonNull(serverOptions);
    }

    public List<String> getRefPrefixes() {
        return this.refPrefixes;
    }

    public boolean getSymrefs() {
        return this.symrefs;
    }

    public boolean getPeel() {
        return this.peel;
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ LsRefsV2Request(List list, boolean bl, boolean bl2, String string, List list2, LsRefsV2Request lsRefsV2Request) {
        this(list, bl, bl2, string, list2);
    }

    public static final class Builder {
        private List<String> refPrefixes = Collections.emptyList();
        private boolean symrefs;
        private boolean peel;
        private final List<String> serverOptions = new ArrayList<String>();
        private String agent;

        private Builder() {
        }

        public Builder setRefPrefixes(List<String> value) {
            this.refPrefixes = value;
            return this;
        }

        public Builder setSymrefs(boolean value) {
            this.symrefs = value;
            return this;
        }

        public Builder setPeel(boolean value) {
            this.peel = value;
            return this;
        }

        public Builder addServerOption(String value) {
            this.serverOptions.add(value);
            return this;
        }

        public Builder setAgent(String value) {
            this.agent = value;
            return this;
        }

        public LsRefsV2Request build() {
            return new LsRefsV2Request(Collections.unmodifiableList(this.refPrefixes), this.symrefs, this.peel, this.agent, Collections.unmodifiableList(this.serverOptions), null);
        }
    }
}

