/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.util.RefList;

public abstract class RefWriter {
    private final Collection<Ref> refs;

    public RefWriter(RefList<Ref> refs) {
        this.refs = refs.asList();
    }

    public void writePackedRefs() throws IOException {
        boolean peeled = false;
        for (Ref r : this.refs) {
            if (!r.getStorage().isPacked() || !r.isPeeled()) continue;
            peeled = true;
            break;
        }
        StringWriter w = new StringWriter();
        if (peeled) {
            w.write("# pack-refs with:");
            if (peeled) {
                w.write(" peeled");
            }
            w.write(10);
        }
        char[] tmp = new char[40];
        for (Ref r : this.refs) {
            if (r.getStorage() != Ref.Storage.PACKED) continue;
            ObjectId objectId = r.getObjectId();
            if (objectId == null) {
                throw new NullPointerException();
            }
            objectId.copyTo(tmp, w);
            w.write(32);
            w.write(r.getName());
            w.write(10);
            ObjectId peeledObjectId = r.getPeeledObjectId();
            if (peeledObjectId == null) continue;
            w.write(94);
            peeledObjectId.copyTo(tmp, w);
            w.write(10);
        }
        this.writeFile("packed-refs", Constants.encode(w.toString()));
    }

    protected abstract void writeFile(String var1, byte[] var2) throws IOException;
}

