/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GpgSigner {
    private static final Logger LOG = LoggerFactory.getLogger(GpgSigner.class);
    private static GpgSigner defaultSigner = GpgSigner.loadGpgSigner();

    private static GpgSigner loadGpgSigner() {
        try {
            ServiceLoader<GpgSigner> loader = ServiceLoader.load(GpgSigner.class);
            Iterator<GpgSigner> iter = loader.iterator();
            if (iter.hasNext()) {
                return iter.next();
            }
        }
        catch (ServiceConfigurationError e) {
            LOG.error(e.getMessage(), e);
        }
        return null;
    }

    public static GpgSigner getDefault() {
        return defaultSigner;
    }

    public abstract void sign(CommitBuilder var1, String var2, PersonIdent var3, CredentialsProvider var4) throws CanceledException;
}

