/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

public abstract class SshSessionFactory {
    private static SshSessionFactory INSTANCE = SshSessionFactory.loadSshSessionFactory();

    private static SshSessionFactory loadSshSessionFactory() {
        ServiceLoader<SshSessionFactory> loader = ServiceLoader.load(SshSessionFactory.class);
        Iterator<SshSessionFactory> iter = loader.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public static SshSessionFactory getInstance() {
        return INSTANCE;
    }

    public abstract RemoteSession getSession(URIish var1, CredentialsProvider var2, FS var3, int var4) throws TransportException;

    public void releaseSession(RemoteSession session) {
        session.disconnect();
    }
}

