/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.builder;

import java.util.HashMap;
import java.util.Map;

public class JavaVersion {
    private static JavaVersion latestVersion;
    private static final Map<Integer, JavaVersion> byVersion;
    public static final JavaVersion JAVA_5;
    public static final JavaVersion JAVA_6;
    public static final JavaVersion JAVA_7;
    public static final JavaVersion JAVA_8;
    public static final JavaVersion JAVA_9;
    public static final JavaVersion JAVA_10;
    public static final JavaVersion JAVA_11;
    public static final JavaVersion JAVA_12;
    public static final JavaVersion JAVA_13;
    public static final JavaVersion JAVA_14;
    public static final JavaVersion JAVA_15;
    public static final JavaVersion JAVA_16;
    public static final JavaVersion JAVA_17;
    public static final JavaVersion JAVA_18;
    public static final JavaVersion JAVA_19;
    public static final JavaVersion JAVA_20;
    public static final JavaVersion JAVA_21;
    public static final JavaVersion JAVA_22;
    public static final JavaVersion JAVA_23;
    private final String name;
    private final int version;
    private final boolean unknown;

    private JavaVersion(String name, int version) {
        this(name, version, false);
        if (latestVersion == null || version > latestVersion.getVersion()) {
            latestVersion = this;
        }
    }

    private JavaVersion(String name, int version, boolean unknown) {
        this.name = name;
        this.version = version;
        this.unknown = unknown;
        byVersion.put(version, this);
    }

    public String toString() {
        return this.getName();
    }

    public static JavaVersion getByVersion(int version) {
        JavaVersion java = byVersion.get(version);
        if (java == null) {
            java = new JavaVersion("Java " + (version - 44) + " [" + version + "]*", version, true);
        }
        return java;
    }

    public static JavaVersion getLatestVersion() {
        return latestVersion;
    }

    public static JavaVersion getCurrentVersion() {
        return JavaVersion.getByVersion((int)Float.parseFloat(System.getProperty("java.class.version")));
    }

    public static String printVersions(int[] versions) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int v : versions) {
            JavaVersion found = JavaVersion.getByVersion(v);
            sb.append(found);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    static {
        byVersion = new HashMap<Integer, JavaVersion>();
        JAVA_5 = new JavaVersion("Java 5", 49);
        JAVA_6 = new JavaVersion("Java 6", 50);
        JAVA_7 = new JavaVersion("Java 7", 51);
        JAVA_8 = new JavaVersion("Java 8", 52);
        JAVA_9 = new JavaVersion("Java 9", 53);
        JAVA_10 = new JavaVersion("Java 10", 54);
        JAVA_11 = new JavaVersion("Java 11", 55);
        JAVA_12 = new JavaVersion("Java 12", 56);
        JAVA_13 = new JavaVersion("Java 13", 57);
        JAVA_14 = new JavaVersion("Java 14", 58);
        JAVA_15 = new JavaVersion("Java 15", 59);
        JAVA_16 = new JavaVersion("Java 16", 60);
        JAVA_17 = new JavaVersion("Java 17", 61);
        JAVA_18 = new JavaVersion("Java 18", 62);
        JAVA_19 = new JavaVersion("Java 19", 63);
        JAVA_20 = new JavaVersion("Java 20", 64);
        JAVA_21 = new JavaVersion("Java 21", 65);
        JAVA_22 = new JavaVersion("Java 22", 66);
        JAVA_23 = new JavaVersion("Java 23", 67);
    }
}

