/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc.builder;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import difflib.DiffUtils;
import difflib.Patch;
import java.beans.ConstructorProperties;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;

public class Builder {
    public static final String LOG_FILE = "BuildTools.log.txt";
    public static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    public static final boolean IS_MAC = System.getProperty("os.name").startsWith("Mac");
    public static final File CWD = new File(".");
    public static final String MC_VERSION = "1.8";
    private static final File jacobeDir = new File("jacobe");
    private static boolean dontUpdate;

    public static void main(String[] args) throws Exception {
        File spigotServer;
        File vanillaJar;
        File maven;
        File buildData;
        File spigot;
        File craftBukkit;
        for (String s : args) {
            if ("--disable-certificate-check".equals(s)) {
                Builder.disableHttpsCertificateCheck();
            }
            if (!"--dont-update".equals(s)) continue;
            dontUpdate = true;
        }
        Builder.logOutput();
        if (IS_MAC) {
            System.out.println("Sorry, but Macintosh is not currently a supported platform for compilation at this time.");
            System.out.println("Please run this script on a Windows or Linux PC and then copy the jars to this computer.");
            System.exit(1);
        }
        try {
            Builder.runProcess(CWD, "bash", "-c", "exit");
        }
        catch (Exception ex) {
            System.out.println("You must run this jar through bash (msysgit)");
            System.exit(1);
        }
        try {
            Builder.runProcess(CWD, "git", "config", "--global", "user.name");
        }
        catch (Exception ex) {
            System.out.println("Git name not set, setting it to default value.");
            Builder.runProcess(CWD, "git", "config", "--global", "user.name", "BuildTools");
        }
        try {
            Builder.runProcess(CWD, "git", "config", "--global", "user.email");
        }
        catch (Exception ex) {
            System.out.println("Git email not set, setting it to default value.");
            Builder.runProcess(CWD, "git", "config", "--global", "user.email", "unconfigured@null.spigotmc.org");
        }
        File workDir = new File("work");
        workDir.mkdir();
        File bukkit = new File("Bukkit");
        if (!bukkit.exists()) {
            Builder.clone("https://hub.spigotmc.org/stash/scm/spigot/bukkit.git", bukkit);
        }
        if (!(craftBukkit = new File("CraftBukkit")).exists()) {
            Builder.clone("https://hub.spigotmc.org/stash/scm/spigot/craftbukkit.git", craftBukkit);
        }
        if (!(spigot = new File("Spigot")).exists()) {
            Builder.clone("https://hub.spigotmc.org/stash/scm/spigot/spigot.git", spigot);
        }
        if (!(buildData = new File("BuildData")).exists()) {
            Builder.clone("https://hub.spigotmc.org/stash/scm/spigot/builddata.git", buildData);
        }
        if (!jacobeDir.exists()) {
            System.out.println("Jacobe does not exist, downloading");
            Builder.getJacobe();
        }
        if (!(maven = new File("apache-maven-3.2.3")).exists()) {
            System.out.println("Maven does not exist, downloading. Please wait.");
            File mvnTemp = new File("mvn.zip");
            mvnTemp.deleteOnExit();
            Builder.download("http://static.spigotmc.org/maven/apache-maven-3.2.3-bin.zip", mvnTemp);
            Builder.unzip(mvnTemp, new File("."));
        }
        String mvn = maven.getAbsolutePath() + "/bin/mvn";
        Git bukkitGit = Git.open(bukkit);
        Git craftBukkitGit = Git.open(craftBukkit);
        Git spigotGit = Git.open(spigot);
        Git buildGit = Git.open(buildData);
        if (!dontUpdate) {
            Builder.pull(bukkitGit);
            Builder.pull(craftBukkitGit);
            Builder.pull(spigotGit);
            Builder.pull(buildGit);
        }
        if (!(vanillaJar = new File(workDir, "minecraft_server.1.8.jar")).exists()) {
            Builder.download(String.format("https://s3.amazonaws.com/Minecraft.Download/versions/%1$s/minecraft_server.%1$s.jar", MC_VERSION), vanillaJar);
        }
        Object mappings = buildGit.log().addPath("mappings/bukkit-1.8.at").addPath("mappings/bukkit-1.8-cl.csrg").addPath("mappings/bukkit-1.8-members.csrg").addPath("mappings/package.srg").setMaxCount(1).call();
        Hasher mappingsHash = Hashing.md5().newHasher();
        Iterator i$ = mappings.iterator();
        while (i$.hasNext()) {
            RevCommit rev = (RevCommit)i$.next();
            mappingsHash.putString(rev.getName(), Charsets.UTF_8);
        }
        String mappingsVersion = mappingsHash.hash().toString().substring(24);
        File finalMappedJar = new File(workDir, "mapped." + mappingsVersion + ".jar");
        if (!finalMappedJar.exists()) {
            System.out.println("Final mapped jar: " + finalMappedJar + " does not exist, creating!");
            File clMappedJar = new File(finalMappedJar + "-cl");
            File mMappedJar = new File(finalMappedJar + "-m");
            Builder.runProcess(CWD, "java", "-jar", "BuildData/bin/SpecialSource.jar", "-i", vanillaJar.getPath(), "-m", "BuildData/mappings/bukkit-1.8-cl.csrg", "-o", clMappedJar.getPath());
            Builder.runProcess(CWD, "java", "-jar", "BuildData/bin/SpecialSource-2.jar", "map", "-i", clMappedJar.getPath(), "-m", "BuildData/mappings/bukkit-1.8-members.csrg", "-o", mMappedJar.getPath());
            Builder.runProcess(CWD, "java", "-jar", "BuildData/bin/SpecialSource.jar", "-i", mMappedJar.getPath(), "--access-transformer", "BuildData/mappings/bukkit-1.8.at", "-m", "BuildData/mappings/package.srg", "-o", finalMappedJar.getPath());
        }
        Builder.runProcess(CWD, "sh", mvn, "install:install-file", "-Dfile=" + finalMappedJar, "-Dpackaging=jar", "-DgroupId=org.spigotmc", "-DartifactId=minecraft-server", "-Dversion=1.8-SNAPSHOT");
        File decompileDir = new File(workDir, "decompile-" + mappingsVersion);
        if (!decompileDir.exists()) {
            decompileDir.mkdir();
            File clazzDir = new File(decompileDir, "classes");
            Builder.unzip(finalMappedJar, clazzDir, new Predicate<String>(){

                @Override
                public boolean apply(String input) {
                    return input.startsWith("net/minecraft/server");
                }
            });
            Builder.runProcess(CWD, "java", "-jar", "BuildData/bin/fernflower.jar", "-dgs=1", "-hdc=0", "-rbr=0", "-asc=1", clazzDir.getPath(), decompileDir.getPath());
            String jacobePath = jacobeDir.getPath() + "/jacobe";
            if (IS_WINDOWS) {
                jacobePath = jacobePath + ".exe";
            }
            Builder.runProcess(CWD, jacobePath, "-cfg=BuildData/bin/jacobe.cfg", "-nobackup", "-overwrite", "-outext=java", decompileDir + "/net/minecraft/server");
        }
        System.out.println("Applying CraftBukkit Patches");
        File nmsDir = new File(craftBukkit, "src/main/java/net");
        if (nmsDir.exists()) {
            System.out.println("Backing up NMS dir");
            FileUtils.moveDirectory(nmsDir, new File(workDir, "nms.old." + System.currentTimeMillis()));
        }
        File patchDir = new File(craftBukkit, "nms-patches");
        for (File file : patchDir.listFiles()) {
            String targetFile = "net/minecraft/server/" + file.getName().replaceAll(".patch", ".java");
            File clean = new File(decompileDir, targetFile);
            File t = new File(nmsDir.getParentFile(), targetFile);
            t.getParentFile().mkdirs();
            System.out.println("Patching with " + file.getName());
            Patch parsedPatch = DiffUtils.parseUnifiedDiff(Files.readLines(file, Charsets.UTF_8));
            List<String> modifiedLines = DiffUtils.patch(Files.readLines(clean, Charsets.UTF_8), parsedPatch);
            BufferedWriter bw = new BufferedWriter(new FileWriter(t));
            for (String line : modifiedLines) {
                bw.write(line);
                bw.newLine();
            }
            bw.close();
        }
        File tmpNms = new File(craftBukkit, "tmp-nms");
        FileUtils.copyDirectory(nmsDir, tmpNms);
        craftBukkitGit.branchDelete().setBranchNames("patched").setForce(true).call();
        craftBukkitGit.checkout().setCreateBranch(true).setForce(true).setName("patched").call();
        craftBukkitGit.add().addFilepattern("src/main/java/net/").call();
        craftBukkitGit.commit().setMessage("CraftBukkit $ " + new Date()).call();
        craftBukkitGit.checkout().setName("master").call();
        FileUtils.moveDirectory(tmpNms, nmsDir);
        File spigotApi = new File(spigot, "Bukkit");
        if (!spigotApi.exists()) {
            Builder.clone("file://" + bukkit.getAbsolutePath(), spigotApi);
        }
        if (!(spigotServer = new File(spigot, "CraftBukkit")).exists()) {
            Builder.clone("file://" + craftBukkit.getAbsolutePath(), spigotServer);
        }
        System.out.println("Compiling Bukkit");
        Builder.runProcess(bukkit, "sh", mvn, "clean", "install");
        System.out.println("Compiling CraftBukkit");
        Builder.runProcess(craftBukkit, "sh", mvn, "clean", "install");
        try {
            Builder.runProcess(spigot, "bash", "applyPatches.sh");
            System.out.println("*** Spigot patches applied!");
            System.out.println("Compiling Spigot & Spigot-API");
            Builder.runProcess(spigot, "sh", mvn, "clean", "install");
        }
        catch (Exception ex) {
            System.err.println("Error compiling Spigot, are you running this jar via msysgit?");
            ex.printStackTrace();
            System.exit(1);
        }
        for (int i = 0; i < 35; ++i) {
            System.out.println(" ");
        }
        System.out.println("Success! Everything compiled successfully. Copying final .jar files now.");
        Builder.copyJar("CraftBukkit/target", "craftbukkit", "craftbukkit-1.8.jar");
        Builder.copyJar("Spigot/Spigot-Server/target", "spigot", "spigot-1.8.jar");
    }

    public static void copyJar(String path, final String jarPrefix, String outJarName) throws Exception {
        File[] files;
        for (File file : files = new File(path).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(jarPrefix) && name.endsWith(".jar");
            }
        })) {
            System.out.println("Copying " + file.getName() + " to " + CWD.getAbsolutePath());
            Files.copy(file, new File(CWD, outJarName));
            System.out.println("  - Saved as " + outJarName);
        }
    }

    public static void getJacobe() throws Exception {
        if (IS_WINDOWS) {
            File jacobeWindows = new File("jacobe.win32.zip");
            Builder.download("http://www.tiobe.com/content/products/jacobe/jacobe.win32.zip", jacobeWindows);
            Builder.unzip(jacobeWindows, jacobeDir);
        } else {
            File jacobeLinux = new File("jacobe.linux.tar.gz");
            Builder.download("http://www.tiobe.com/content/products/jacobe/jacobe.linux.tar.gz", jacobeLinux);
            jacobeDir.mkdir();
            Builder.runProcess(CWD, "tar", "xzvf", jacobeLinux.getPath(), "-C", jacobeDir.getPath());
        }
    }

    public static void pull(Git repo) throws Exception {
        System.out.println("Pulling updates for " + repo.getRepository().getDirectory());
        repo.reset().setRef("origin/master").setMode(ResetCommand.ResetType.HARD).call();
        boolean result = repo.pull().call().isSuccessful();
        if (!result) {
            throw new RuntimeException("Could not pull updates!");
        }
        System.out.println("Successfully pulled updates!");
    }

    public static int runProcess(File workDir, String ... command) throws Exception {
        Process ps = new ProcessBuilder(command).directory(workDir).start();
        new Thread(new StreamRedirector(ps.getInputStream(), System.out)).start();
        new Thread(new StreamRedirector(ps.getErrorStream(), System.err)).start();
        int status = ps.waitFor();
        if (status != 0) {
            throw new RuntimeException("Error running command, return status !=0: " + Arrays.toString(command));
        }
        return status;
    }

    public static void unzip(File zipFile, File targetFolder) throws IOException {
        Builder.unzip(zipFile, targetFolder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File targetFolder, Predicate<String> filter) throws IOException {
        targetFolder.mkdir();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (filter != null && !filter.apply(entry.getName())) continue;
            File outFile = new File(targetFolder, entry.getName());
            if (entry.isDirectory()) {
                outFile.mkdirs();
                continue;
            }
            if (outFile.getParentFile() != null) {
                outFile.getParentFile().mkdirs();
            }
            InputStream is = zip.getInputStream(entry);
            FileOutputStream os = new FileOutputStream(outFile);
            try {
                ByteStreams.copy(is, os);
            }
            finally {
                is.close();
                ((OutputStream)os).close();
            }
            System.out.println("Extracted: " + outFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clone(String url, File target) throws GitAPIException {
        System.out.println("Starting clone of " + url + " to " + target);
        Git result = Git.cloneRepository().setURI(url).setDirectory(target).call();
        try {
            System.out.println("Cloned git repository " + url + " to " + url + ". Current HEAD: " + Builder.commitHash(result));
        }
        finally {
            result.close();
        }
    }

    public static String commitHash(Git repo) throws GitAPIException {
        return ((RevCommit)Iterables.getOnlyElement(repo.log().setMaxCount(1).call())).getName();
    }

    public static File download(String url, File target) throws IOException {
        System.out.println("Starting download of " + url);
        byte[] bytes = Resources.toByteArray(new URL(url));
        System.out.println("Downloaded file: " + target + " with md5: " + Hashing.md5().hashBytes(bytes).toString());
        Files.write(bytes, target);
        return target;
    }

    public static void disableHttpsCertificateCheck() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Failed to disable https certificate check");
            ex.printStackTrace(System.err);
        }
        catch (KeyManagementException ex) {
            System.out.println("Failed to disable https certificate check");
            ex.printStackTrace(System.err);
        }
    }

    public static void logOutput() {
        try {
            final BufferedOutputStream logOut = new BufferedOutputStream(new FileOutputStream(LOG_FILE));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out)));
                    System.setErr(new PrintStream(new FileOutputStream(FileDescriptor.err)));
                    try {
                        logOut.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            System.setOut(new PrintStream(new TeeOutputStream(System.out, logOut)));
            System.setErr(new PrintStream(new TeeOutputStream(System.err, logOut)));
        }
        catch (FileNotFoundException ex) {
            System.err.println("Failed to create log file: BuildTools.log.txt");
        }
    }

    private static class StreamRedirector
    implements Runnable {
        private final InputStream in;
        private final PrintStream out;

        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.out.println(line);
                }
            }
            catch (IOException ex) {
                throw Throwables.propagate(ex);
            }
        }

        @ConstructorProperties(value={"in", "out"})
        public StreamRedirector(InputStream in, PrintStream out) {
            this.in = in;
            this.out = out;
        }
    }
}

