/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.compress.CompressFactory;
import net.md_5.bungee.jni.zlib.BungeeZlib;
import net.md_5.bungee.protocol.DefinedPacket;

public class LengthPrependerAndCompressor
extends MessageToMessageEncoder<ByteBuf> {
    private static final byte MAX_SUPPORTED_VARINT_LENGTH_LEN = 4;
    private static final byte FLAG_COMPRESS = 1;
    private static final byte FLAG_COMPOSE = 2;
    private static final byte FLAG_TWO_BUFFERS = 4;
    private BungeeZlib zlib;
    private int threshold = 256;
    private byte flags = (byte)2;

    public LengthPrependerAndCompressor(boolean compose, boolean twoBuffers) {
        this.setCompose(compose);
        this.setTwoBuffers(twoBuffers);
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int oldBodyLen = msg.readableBytes();
        byte flags = this.flags;
        if ((flags & 1) != 0) {
            if (oldBodyLen < this.threshold) {
                byte lengthLen = LengthPrependerAndCompressor.varintSize(oldBodyLen + 1);
                if ((flags & 4) != 0) {
                    ByteBuf lenBuf = ctx.alloc().directBuffer((int)lengthLen);
                    DefinedPacket.writeVarInt((int)(oldBodyLen + 1), (ByteBuf)lenBuf);
                    lenBuf.writeByte(0);
                    out.add(lenBuf);
                    out.add(msg.retain());
                } else if ((flags & 2) != 0) {
                    ByteBuf pre = ctx.alloc().directBuffer(lengthLen + 1);
                    DefinedPacket.writeVarInt((int)(oldBodyLen + 1), (ByteBuf)pre);
                    pre.writeByte(0);
                    out.add(ctx.alloc().compositeDirectBuffer(2).addComponents(true, new ByteBuf[]{pre, msg.retain()}));
                } else {
                    ByteBuf buf = ctx.alloc().directBuffer(lengthLen + 1 + oldBodyLen);
                    DefinedPacket.writeVarInt((int)(oldBodyLen + 1), (ByteBuf)buf);
                    out.add(buf.writeByte(0).writeBytes(msg));
                }
            } else {
                ByteBuf buf = ctx.alloc().directBuffer(8196 + LengthPrependerAndCompressor.varintSize(oldBodyLen));
                buf.writerIndex(4);
                DefinedPacket.writeVarInt((int)oldBodyLen, (ByteBuf)buf);
                this.zlib.process(msg, buf);
                int writerIndex = buf.writerIndex();
                int compressedLen = writerIndex - 4;
                byte lengthLen = LengthPrependerAndCompressor.varintSize(compressedLen);
                int lengthStart = 4 - lengthLen;
                DefinedPacket.setVarInt((int)compressedLen, (ByteBuf)buf, (int)lengthStart, (int)lengthLen);
                buf.readerIndex(lengthStart);
                out.add(buf);
            }
        } else {
            byte lengthLen = LengthPrependerAndCompressor.varintSize(oldBodyLen);
            if ((flags & 4) != 0) {
                ByteBuf lenBuf = ctx.alloc().directBuffer((int)lengthLen);
                DefinedPacket.writeVarInt((int)oldBodyLen, (ByteBuf)lenBuf);
                out.add(lenBuf);
                out.add(msg.retain());
            } else if ((flags & 2) != 0) {
                ByteBuf pre = ctx.alloc().directBuffer((int)lengthLen);
                DefinedPacket.writeVarInt((int)oldBodyLen, (ByteBuf)pre);
                out.add(ctx.alloc().compositeDirectBuffer(2).addComponents(true, new ByteBuf[]{pre, msg.retain()}));
            } else {
                ByteBuf buf = ctx.alloc().directBuffer(lengthLen + oldBodyLen);
                DefinedPacket.writeVarInt((int)oldBodyLen, (ByteBuf)buf);
                out.add(buf.writeBytes(msg));
            }
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.zlib != null) {
            this.zlib.free();
            this.zlib = null;
        }
    }

    public void setCompose(boolean compose) {
        this.flags = compose ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public boolean isCompress() {
        return (this.flags & 1) != 0;
    }

    public void setCompress(boolean compress) {
        if (compress) {
            BungeeZlib zlib = this.zlib;
            if (zlib == null) {
                this.zlib = zlib = (BungeeZlib)CompressFactory.zlib.newInstance();
            }
            zlib.init(true, -1);
            this.flags = (byte)(this.flags | 1);
        } else {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            if (this.zlib != null) {
                this.zlib.free();
                this.zlib = null;
            }
        }
    }

    public void setTwoBuffers(boolean twoBuffers) {
        this.flags = twoBuffers ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    private static byte varintSize(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        throw new IllegalArgumentException("Packet length " + value + " longer than supported (max. 268435455 for 4 byte varint)");
    }

    @Generated
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

