/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.forge;

import java.util.Map;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.forge.ForgeLogger;
import net.md_5.bungee.forge.ForgeUtils;
import net.md_5.bungee.forge.IForgeClientPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;

enum ForgeClientHandshakeState implements IForgeClientPacketHandler<ForgeClientHandshakeState>
{
    START{

        @Override
        public ForgeClientHandshakeState handle(PluginMessage message, UserConnection con) {
            ForgeLogger.logClient(ForgeLogger.LogDirection.RECEIVED, this.name(), message);
            con.unsafe().sendPacket((DefinedPacket)message);
            con.getForgeClientHandler().setState(HELLO);
            return HELLO;
        }

        @Override
        public ForgeClientHandshakeState send(PluginMessage message, UserConnection con) {
            return HELLO;
        }
    }
    ,
    HELLO{

        @Override
        public ForgeClientHandshakeState handle(PluginMessage message, UserConnection con) {
            ForgeLogger.logClient(ForgeLogger.LogDirection.RECEIVED, this.name(), message);
            if (message.getData()[0] == 0) {
                con.unsafe().sendPacket((DefinedPacket)message);
            }
            return this;
        }

        @Override
        public ForgeClientHandshakeState send(PluginMessage message, UserConnection con) {
            if (message.getData()[0] == 1) {
                return this;
            }
            if (message.getData()[0] == 2) {
                if (con.getForgeClientHandler().getClientModList() == null) {
                    Map<String, String> clientModList = ForgeUtils.readModList(message);
                    con.getForgeClientHandler().setClientModList(clientModList);
                }
                return WAITINGSERVERDATA;
            }
            return this;
        }
    }
    ,
    WAITINGSERVERDATA{

        @Override
        public ForgeClientHandshakeState handle(PluginMessage message, UserConnection con) {
            ForgeLogger.logClient(ForgeLogger.LogDirection.RECEIVED, this.name(), message);
            if (message.getData()[0] == 2) {
                con.unsafe().sendPacket((DefinedPacket)message);
            }
            return this;
        }

        @Override
        public ForgeClientHandshakeState send(PluginMessage message, UserConnection con) {
            return WAITINGSERVERCOMPLETE;
        }
    }
    ,
    WAITINGSERVERCOMPLETE{

        @Override
        public ForgeClientHandshakeState handle(PluginMessage message, UserConnection con) {
            ForgeLogger.logClient(ForgeLogger.LogDirection.RECEIVED, this.name(), message);
            if (message.getData()[0] == 3) {
                con.unsafe().sendPacket((DefinedPacket)message);
                return this;
            }
            con.unsafe().sendPacket((DefinedPacket)message);
            return this;
        }

        @Override
        public ForgeClientHandshakeState send(PluginMessage message, UserConnection con) {
            return PENDINGCOMPLETE;
        }
    }
    ,
    PENDINGCOMPLETE{

        @Override
        public ForgeClientHandshakeState handle(PluginMessage message, UserConnection con) {
            if (message.getData()[0] == -1) {
                ForgeLogger.logClient(ForgeLogger.LogDirection.RECEIVED, this.name(), message);
                con.unsafe().sendPacket((DefinedPacket)message);
            }
            return this;
        }

        @Override
        public ForgeClientHandshakeState send(PluginMessage message, UserConnection con) {
            return COMPLETE;
        }
    }
    ,
    COMPLETE{

        @Override
        public ForgeClientHandshakeState handle(PluginMessage message, UserConnection con) {
            if (message.getData()[0] == -1) {
                ForgeLogger.logClient(ForgeLogger.LogDirection.RECEIVED, this.name(), message);
                con.unsafe().sendPacket((DefinedPacket)message);
            }
            return this;
        }

        @Override
        public ForgeClientHandshakeState send(PluginMessage message, UserConnection con) {
            return DONE;
        }
    }
    ,
    DONE{

        @Override
        public ForgeClientHandshakeState handle(PluginMessage message, UserConnection con) {
            ForgeLogger.logClient(ForgeLogger.LogDirection.RECEIVED, this.name(), message);
            return this;
        }

        @Override
        public ForgeClientHandshakeState send(PluginMessage message, UserConnection con) {
            return this;
        }
    };

}

