/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.ChatChain;
import net.md_5.bungee.protocol.data.SeenMessages;

public class ClientCommand
extends DefinedPacket {
    private String command;
    private long timestamp;
    private long salt;
    private Map<String, byte[]> signatures;
    private boolean signedPreview;
    private ChatChain chain;
    private SeenMessages seenMessages;
    private byte checksum;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.command = ClientCommand.readString(buf, protocolVersion >= 766 ? Short.MAX_VALUE : 256);
        this.timestamp = buf.readLong();
        this.salt = buf.readLong();
        int cnt = ClientCommand.readVarInt(buf);
        Preconditions.checkArgument((cnt <= 8 ? 1 : 0) != 0, (Object)"Too many signatures");
        this.signatures = new HashMap<String, byte[]>(cnt);
        for (int i = 0; i < cnt; ++i) {
            byte[] signature;
            String name = ClientCommand.readString(buf, 16);
            if (protocolVersion >= 761) {
                signature = new byte[256];
                buf.readBytes(signature);
            } else {
                signature = ClientCommand.readArray(buf);
            }
            this.signatures.put(name, signature);
        }
        if (protocolVersion < 761) {
            this.signedPreview = buf.readBoolean();
        }
        if (protocolVersion >= 761) {
            this.seenMessages = new SeenMessages();
            this.seenMessages.read(buf, direction, protocolVersion);
        } else if (protocolVersion >= 760) {
            this.chain = new ChatChain();
            this.chain.read(buf, direction, protocolVersion);
        }
        if (protocolVersion >= 770) {
            this.checksum = buf.readByte();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ClientCommand.writeString(this.command, buf);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.salt);
        ClientCommand.writeVarInt(this.signatures.size(), buf);
        for (Map.Entry<String, byte[]> entry : this.signatures.entrySet()) {
            ClientCommand.writeString(entry.getKey(), buf);
            if (protocolVersion >= 761) {
                buf.writeBytes(entry.getValue());
                continue;
            }
            ClientCommand.writeArray(entry.getValue(), buf);
        }
        if (protocolVersion < 761) {
            buf.writeBoolean(this.signedPreview);
        }
        if (protocolVersion >= 761) {
            this.seenMessages.write(buf, direction, protocolVersion);
        } else if (protocolVersion >= 760) {
            this.chain.write(buf, direction, protocolVersion);
        }
        if (protocolVersion >= 770) {
            buf.writeByte((int)this.checksum);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public long getSalt() {
        return this.salt;
    }

    @Generated
    public Map<String, byte[]> getSignatures() {
        return this.signatures;
    }

    @Generated
    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    @Generated
    public ChatChain getChain() {
        return this.chain;
    }

    @Generated
    public SeenMessages getSeenMessages() {
        return this.seenMessages;
    }

    @Generated
    public byte getChecksum() {
        return this.checksum;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setSalt(long salt) {
        this.salt = salt;
    }

    @Generated
    public void setSignatures(Map<String, byte[]> signatures) {
        this.signatures = signatures;
    }

    @Generated
    public void setSignedPreview(boolean signedPreview) {
        this.signedPreview = signedPreview;
    }

    @Generated
    public void setChain(ChatChain chain) {
        this.chain = chain;
    }

    @Generated
    public void setSeenMessages(SeenMessages seenMessages) {
        this.seenMessages = seenMessages;
    }

    @Generated
    public void setChecksum(byte checksum) {
        this.checksum = checksum;
    }

    @Override
    @Generated
    public String toString() {
        return "ClientCommand(command=" + this.getCommand() + ", timestamp=" + this.getTimestamp() + ", salt=" + this.getSalt() + ", signatures=" + this.getSignatures() + ", signedPreview=" + this.isSignedPreview() + ", chain=" + this.getChain() + ", seenMessages=" + this.getSeenMessages() + ", checksum=" + this.getChecksum() + ")";
    }

    @Generated
    public ClientCommand() {
    }

    @Generated
    public ClientCommand(String command, long timestamp, long salt, Map<String, byte[]> signatures, boolean signedPreview, ChatChain chain, SeenMessages seenMessages, byte checksum) {
        this.command = command;
        this.timestamp = timestamp;
        this.salt = salt;
        this.signatures = signatures;
        this.signedPreview = signedPreview;
        this.chain = chain;
        this.seenMessages = seenMessages;
        this.checksum = checksum;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientCommand)) {
            return false;
        }
        ClientCommand other = (ClientCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.isSignedPreview() != other.isSignedPreview()) {
            return false;
        }
        if (this.getChecksum() != other.getChecksum()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Map<String, byte[]> this$signatures = this.getSignatures();
        Map<String, byte[]> other$signatures = other.getSignatures();
        if (this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures)) {
            return false;
        }
        ChatChain this$chain = this.getChain();
        ChatChain other$chain = other.getChain();
        if (this$chain == null ? other$chain != null : !((Object)this$chain).equals(other$chain)) {
            return false;
        }
        SeenMessages this$seenMessages = this.getSeenMessages();
        SeenMessages other$seenMessages = other.getSeenMessages();
        return !(this$seenMessages == null ? other$seenMessages != null : !((Object)this$seenMessages).equals(other$seenMessages));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientCommand;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + (this.isSignedPreview() ? 79 : 97);
        result = result * 59 + this.getChecksum();
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Map<String, byte[]> $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        ChatChain $chain = this.getChain();
        result = result * 59 + ($chain == null ? 43 : ((Object)$chain).hashCode());
        SeenMessages $seenMessages = this.getSeenMessages();
        result = result * 59 + ($seenMessages == null ? 43 : ((Object)$seenMessages).hashCode());
        return result;
    }
}

