// Generated by delombok at Fri Nov 21 22:30:45 UTC 2025
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.exception.NBTFormatException;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class CompoundTag implements TypedTag {
    private static final int MAP_SIZE_IN_BYTES = 48;
    private static final int MAP_ENTRY_SIZE_IN_BYTES = 32;
    //
    private Map<String, TypedTag> value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.push();
        limiter.countBytes(MAP_SIZE_IN_BYTES);
        Map<String, TypedTag> map = new LinkedHashMap<>();
        for (byte type; (type = input.readByte()) != Tag.END; ) {
            String name = readString(input, limiter);
            TypedTag tag = Tag.readById(type, input, limiter);
            if (map.put(name, tag) == null) {
                limiter.countBytes(MAP_ENTRY_SIZE_IN_BYTES + OBJECT_REFERENCE);
            }
        }
        limiter.pop();
        value = map;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(value, "compound tag map cannot be null");
        for (Map.Entry<String, TypedTag> entry : value.entrySet()) {
            String name = entry.getKey();
            TypedTag tag = entry.getValue();
            output.writeByte(tag.getId());
            if (tag.getId() == Tag.END) {
                throw new NBTFormatException("invalid end tag in compound tag");
            }
            writeString(name, output);
            tag.write(output);
        }
        output.writeByte(0);
    }

    @Override
    public byte getId() {
        return Tag.COMPOUND;
    }

    public static String readString(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(STRING_SIZE);
        String string = input.readUTF();
        limiter.countBytes(string.length(), Character.BYTES);
        return string;
    }

    public static void writeString(String string, DataOutput output) throws IOException {
        output.writeUTF(string);
    }

    public TypedTag get(String key) {
        return value.get(key);
    }

    public void put(String key, TypedTag tag) {
        value.put(key, tag);
    }

    public int size() {
        return value.size();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, TypedTag> getValue() {
        return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final Map<String, TypedTag> value) {
        this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CompoundTag)) return false;
        final CompoundTag other = (CompoundTag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CompoundTag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CompoundTag(value=" + this.getValue() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CompoundTag() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CompoundTag(final Map<String, TypedTag> value) {
        this.value = value;
    }
}
