// Generated by delombok at Fri Nov 21 22:30:45 UTC 2025
package net.md_5.bungee.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.md_5.bungee.nbt.limit.NBTLimiter;
import net.md_5.bungee.nbt.type.CompoundTag;

public class NamedTag implements Tag {
    private String name;
    private TypedTag tag;

    /**
     * Reads the data of the {@link DataInput} and parses it into this
     * {@link NamedTag}.
     *
     * @param input input to read from
     * @param limiter limitation of the read data
     */
    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        byte type = input.readByte();
        name = CompoundTag.readString(input, limiter);
        tag = Tag.readById(type, input, limiter);
    }

    /**
     * Write this {@link NamedTag} into a {@link DataOutput}.
     *
     * @param output the output to write to
     */
    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(tag, "tag cannot be null");
        output.writeByte(tag.getId());
        CompoundTag.writeString(name, output);
        tag.write(output);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TypedTag getTag() {
        return this.tag;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTag(final TypedTag tag) {
        this.tag = tag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof NamedTag)) return false;
        final NamedTag other = (NamedTag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$tag = this.getTag();
        final java.lang.Object other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof NamedTag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $tag = this.getTag();
        result = result * PRIME + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "NamedTag(name=" + this.getName() + ", tag=" + this.getTag() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NamedTag() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NamedTag(final String name, final TypedTag tag) {
        this.name = name;
        this.tag = tag;
    }
}
