/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.jni.cipher;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.FastThreadLocal;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import net.md_5.bungee.jni.cipher.BungeeCipher;

public class JavaCipher
implements BungeeCipher {
    private final Cipher cipher;
    private static final FastThreadLocal<byte[]> heapInLocal = new EmptyByteThreadLocal();
    private static final FastThreadLocal<byte[]> heapOutLocal = new EmptyByteThreadLocal();

    public JavaCipher() {
        try {
            this.cipher = Cipher.getInstance("AES/CFB8/NoPadding");
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void init(boolean forEncryption, SecretKey key) throws GeneralSecurityException {
        int mode = forEncryption ? 1 : 2;
        this.cipher.init(mode, (Key)key, new IvParameterSpec(key.getEncoded()));
    }

    @Override
    public void cipher(ByteBuf in, ByteBuf out) throws ShortBufferException {
        int outputSize;
        int readableBytes = in.readableBytes();
        byte[] heapIn = this.bufToByte(in);
        byte[] heapOut = (byte[])heapOutLocal.get();
        if (heapOut.length < (outputSize = this.cipher.getOutputSize(readableBytes))) {
            heapOut = new byte[outputSize];
            heapOutLocal.set((Object)heapOut);
        }
        out.writeBytes(heapOut, 0, this.cipher.update(heapIn, 0, readableBytes, heapOut));
    }

    @Override
    public ByteBuf cipher(ChannelHandlerContext ctx, ByteBuf in) throws ShortBufferException {
        int readableBytes = in.readableBytes();
        byte[] heapIn = this.bufToByte(in);
        ByteBuf heapOut = ctx.alloc().heapBuffer(this.cipher.getOutputSize(readableBytes));
        heapOut.writerIndex(this.cipher.update(heapIn, 0, readableBytes, heapOut.array(), heapOut.arrayOffset()));
        return heapOut;
    }

    @Override
    public void free() {
    }

    private byte[] bufToByte(ByteBuf in) {
        int readableBytes;
        byte[] heapIn = (byte[])heapInLocal.get();
        if (heapIn.length < (readableBytes = in.readableBytes())) {
            heapIn = new byte[readableBytes];
            heapInLocal.set((Object)heapIn);
        }
        in.readBytes(heapIn, 0, readableBytes);
        return heapIn;
    }

    @Override
    public boolean allowComposite() {
        return true;
    }

    private static class EmptyByteThreadLocal
    extends FastThreadLocal<byte[]> {
        private EmptyByteThreadLocal() {
        }

        protected byte[] initialValue() {
            return new byte[0];
        }
    }
}

