// Generated by delombok at Tue Dec 16 19:34:32 UTC 2025
package net.md_5.bungee.api.dialog;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import lombok.NonNull;
import net.md_5.bungee.api.dialog.action.ActionButton;

/**
 * Represents a dialog which shows the links configured/sent from the server.
 */
public final class ServerLinksDialog implements Dialog {
    @NonNull
    private DialogBase base;
    /**
     * The optional {@link ActionButton} for this dialog.
     */
    @SerializedName("action")
    private ActionButton action;
    /**
     * The {@link ActionButton} activated when the dialog is exited.
     */
    @SerializedName("exit_action")
    private ActionButton exitAction;
    /**
     * The number of columns for the dialog buttons (default: 2).
     */
    private Integer columns;
    /**
     * The width of the dialog buttons (default: 150, minimum: 1, maximum:
     * 1024).
     */
    @SerializedName("button_width")
    private Integer buttonWidth;

    public ServerLinksDialog(@NonNull DialogBase base) {
        this(base, null, null, null);
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
    }

    public ServerLinksDialog(@NonNull DialogBase base, ActionButton action, Integer columns, Integer buttonWidth) {
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
        this.action = action;
        columns(columns);
        buttonWidth(buttonWidth);
    }

    public ServerLinksDialog columns(Integer columns) {
        Preconditions.checkArgument(columns == null || columns > 0, "At least one column is required");
        this.columns = columns;
        return this;
    }

    public ServerLinksDialog buttonWidth(Integer buttonWidth) {
        Preconditions.checkArgument(buttonWidth == null || (buttonWidth >= 1 && buttonWidth <= 1024), "buttonWidth must be between 1 and 1024");
        this.buttonWidth = buttonWidth;
        return this;
    }

    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase getBase() {
        return this.base;
    }

    /**
     * The optional {@link ActionButton} for this dialog.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ActionButton action() {
        return this.action;
    }

    /**
     * The {@link ActionButton} activated when the dialog is exited.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ActionButton exitAction() {
        return this.exitAction;
    }

    /**
     * The number of columns for the dialog buttons (default: 2).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer columns() {
        return this.columns;
    }

    /**
     * The width of the dialog buttons (default: 150, minimum: 1, maximum:
     * 1024).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer buttonWidth() {
        return this.buttonWidth;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBase(@NonNull final DialogBase base) {
        if (base == null) {
            throw new java.lang.NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
    }

    /**
     * The optional {@link ActionButton} for this dialog.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerLinksDialog action(final ActionButton action) {
        this.action = action;
        return this;
    }

    /**
     * The {@link ActionButton} activated when the dialog is exited.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerLinksDialog exitAction(final ActionButton exitAction) {
        this.exitAction = exitAction;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ServerLinksDialog(base=" + this.getBase() + ", action=" + this.action() + ", exitAction=" + this.exitAction() + ", columns=" + this.columns() + ", buttonWidth=" + this.buttonWidth() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServerLinksDialog)) return false;
        final ServerLinksDialog other = (ServerLinksDialog) o;
        final java.lang.Object this$columns = this.columns();
        final java.lang.Object other$columns = other.columns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) return false;
        final java.lang.Object this$buttonWidth = this.buttonWidth();
        final java.lang.Object other$buttonWidth = other.buttonWidth();
        if (this$buttonWidth == null ? other$buttonWidth != null : !this$buttonWidth.equals(other$buttonWidth)) return false;
        final java.lang.Object this$base = this.getBase();
        final java.lang.Object other$base = other.getBase();
        if (this$base == null ? other$base != null : !this$base.equals(other$base)) return false;
        final java.lang.Object this$action = this.action();
        final java.lang.Object other$action = other.action();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) return false;
        final java.lang.Object this$exitAction = this.exitAction();
        final java.lang.Object other$exitAction = other.exitAction();
        if (this$exitAction == null ? other$exitAction != null : !this$exitAction.equals(other$exitAction)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $columns = this.columns();
        result = result * PRIME + ($columns == null ? 43 : $columns.hashCode());
        final java.lang.Object $buttonWidth = this.buttonWidth();
        result = result * PRIME + ($buttonWidth == null ? 43 : $buttonWidth.hashCode());
        final java.lang.Object $base = this.getBase();
        result = result * PRIME + ($base == null ? 43 : $base.hashCode());
        final java.lang.Object $action = this.action();
        result = result * PRIME + ($action == null ? 43 : $action.hashCode());
        final java.lang.Object $exitAction = this.exitAction();
        result = result * PRIME + ($exitAction == null ? 43 : $exitAction.hashCode());
        return result;
    }
}
