// Generated by delombok at Sat Oct 04 04:45:27 UTC 2025
package net.md_5.bungee.api.dialog;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.dialog.body.DialogBody;
import net.md_5.bungee.api.dialog.input.DialogInput;

/**
 * Represents the title and other options common to all dialogs.
 */
public final class DialogBase {
    /**
     * The mandatory dialog title.
     */
    @NonNull
    private BaseComponent title;
    /**
     * The name which is used for any buttons leading to this dialog (eg from a
     * {@link DialogListDialog}). Otherwise defaults to {@link #title}.
     */
    @SerializedName("external_title")
    private BaseComponent externalTitle;
    /**
     * The inputs to the dialog.
     */
    private List<DialogInput> inputs;
    /**
     * The body elements which make up this dialog.
     */
    private List<DialogBody> body;
    /**
     * Whether this dialog can be closed with the escape key (default: true).
     */
    @SerializedName("can_close_with_escape")
    private Boolean canCloseWithEscape;
    /**
     * Whether this dialog should pause the game in single-player mode (default:
     * true).
     */
    private Boolean pause;
    /**
     * Action to take after the a click or submit action is performed on the
     * dialog (default: close).
     */
    @SerializedName("after_action")
    private AfterAction afterAction;

    public DialogBase(@NonNull BaseComponent title) {
        this(title, null, null, null, null, null, null);
        if (title == null) {
            throw new java.lang.NullPointerException("title is marked non-null but is null");
        }
    }


    /**
     * Types of action which may be taken after the dialog.
     */
    public enum AfterAction {
        /**
         * Close the dialog.
         */
        @SerializedName("close")
        CLOSE, /**
         * Do nothing.
         */
        @SerializedName("none")
        NONE, /**
         * Show a waiting for response screen.
         */
        @SerializedName("wait_for_response")
        WAIT_FOR_RESPONSE;
    }

    /**
     * The mandatory dialog title.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent title() {
        return this.title;
    }

    /**
     * The name which is used for any buttons leading to this dialog (eg from a
     * {@link DialogListDialog}). Otherwise defaults to {@link #title}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent externalTitle() {
        return this.externalTitle;
    }

    /**
     * The inputs to the dialog.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<DialogInput> inputs() {
        return this.inputs;
    }

    /**
     * The body elements which make up this dialog.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<DialogBody> body() {
        return this.body;
    }

    /**
     * Whether this dialog can be closed with the escape key (default: true).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean canCloseWithEscape() {
        return this.canCloseWithEscape;
    }

    /**
     * Whether this dialog should pause the game in single-player mode (default:
     * true).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean pause() {
        return this.pause;
    }

    /**
     * Action to take after the a click or submit action is performed on the
     * dialog (default: close).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AfterAction afterAction() {
        return this.afterAction;
    }

    /**
     * The mandatory dialog title.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase title(@NonNull final BaseComponent title) {
        if (title == null) {
            throw new java.lang.NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
        return this;
    }

    /**
     * The name which is used for any buttons leading to this dialog (eg from a
     * {@link DialogListDialog}). Otherwise defaults to {@link #title}.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase externalTitle(final BaseComponent externalTitle) {
        this.externalTitle = externalTitle;
        return this;
    }

    /**
     * The inputs to the dialog.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase inputs(final List<DialogInput> inputs) {
        this.inputs = inputs;
        return this;
    }

    /**
     * The body elements which make up this dialog.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase body(final List<DialogBody> body) {
        this.body = body;
        return this;
    }

    /**
     * Whether this dialog can be closed with the escape key (default: true).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase canCloseWithEscape(final Boolean canCloseWithEscape) {
        this.canCloseWithEscape = canCloseWithEscape;
        return this;
    }

    /**
     * Whether this dialog should pause the game in single-player mode (default:
     * true).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase pause(final Boolean pause) {
        this.pause = pause;
        return this;
    }

    /**
     * Action to take after the a click or submit action is performed on the
     * dialog (default: close).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase afterAction(final AfterAction afterAction) {
        this.afterAction = afterAction;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DialogBase)) return false;
        final DialogBase other = (DialogBase) o;
        final java.lang.Object this$canCloseWithEscape = this.canCloseWithEscape();
        final java.lang.Object other$canCloseWithEscape = other.canCloseWithEscape();
        if (this$canCloseWithEscape == null ? other$canCloseWithEscape != null : !this$canCloseWithEscape.equals(other$canCloseWithEscape)) return false;
        final java.lang.Object this$pause = this.pause();
        final java.lang.Object other$pause = other.pause();
        if (this$pause == null ? other$pause != null : !this$pause.equals(other$pause)) return false;
        final java.lang.Object this$title = this.title();
        final java.lang.Object other$title = other.title();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) return false;
        final java.lang.Object this$externalTitle = this.externalTitle();
        final java.lang.Object other$externalTitle = other.externalTitle();
        if (this$externalTitle == null ? other$externalTitle != null : !this$externalTitle.equals(other$externalTitle)) return false;
        final java.lang.Object this$inputs = this.inputs();
        final java.lang.Object other$inputs = other.inputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) return false;
        final java.lang.Object this$body = this.body();
        final java.lang.Object other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) return false;
        final java.lang.Object this$afterAction = this.afterAction();
        final java.lang.Object other$afterAction = other.afterAction();
        if (this$afterAction == null ? other$afterAction != null : !this$afterAction.equals(other$afterAction)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $canCloseWithEscape = this.canCloseWithEscape();
        result = result * PRIME + ($canCloseWithEscape == null ? 43 : $canCloseWithEscape.hashCode());
        final java.lang.Object $pause = this.pause();
        result = result * PRIME + ($pause == null ? 43 : $pause.hashCode());
        final java.lang.Object $title = this.title();
        result = result * PRIME + ($title == null ? 43 : $title.hashCode());
        final java.lang.Object $externalTitle = this.externalTitle();
        result = result * PRIME + ($externalTitle == null ? 43 : $externalTitle.hashCode());
        final java.lang.Object $inputs = this.inputs();
        result = result * PRIME + ($inputs == null ? 43 : $inputs.hashCode());
        final java.lang.Object $body = this.body();
        result = result * PRIME + ($body == null ? 43 : $body.hashCode());
        final java.lang.Object $afterAction = this.afterAction();
        result = result * PRIME + ($afterAction == null ? 43 : $afterAction.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "DialogBase(title=" + this.title() + ", externalTitle=" + this.externalTitle() + ", inputs=" + this.inputs() + ", body=" + this.body() + ", canCloseWithEscape=" + this.canCloseWithEscape() + ", pause=" + this.pause() + ", afterAction=" + this.afterAction() + ")";
    }

    /**
     * Creates a new {@code DialogBase} instance.
     *
     * @param title The mandatory dialog title.
     * @param externalTitle The name which is used for any buttons leading to this dialog (eg from a
     * {@link DialogListDialog}). Otherwise defaults to {@link #title}.
     * @param inputs The inputs to the dialog.
     * @param body The body elements which make up this dialog.
     * @param canCloseWithEscape Whether this dialog can be closed with the escape key (default: true).
     * @param pause Whether this dialog should pause the game in single-player mode (default:
     * true).
     * @param afterAction Action to take after the a click or submit action is performed on the
     * dialog (default: close).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public DialogBase(@NonNull final BaseComponent title, final BaseComponent externalTitle, final List<DialogInput> inputs, final List<DialogBody> body, final Boolean canCloseWithEscape, final Boolean pause, final AfterAction afterAction) {
        if (title == null) {
            throw new java.lang.NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
        this.externalTitle = externalTitle;
        this.inputs = inputs;
        this.body = body;
        this.canCloseWithEscape = canCloseWithEscape;
        this.pause = pause;
        this.afterAction = afterAction;
    }
}
