// Generated by delombok at Sat Oct 04 04:46:56 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.PlayerPublicKey;

public class LoginRequest extends DefinedPacket {
    private String data;
    private PlayerPublicKey publicKey;
    private UUID uuid;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        data = readString(buf, 16);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19 && protocolVersion < ProtocolConstants.MINECRAFT_1_19_3) {
            publicKey = readPublicKey(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_1) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_2 || buf.readBoolean()) {
                uuid = readUUID(buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(data, buf);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19 && protocolVersion < ProtocolConstants.MINECRAFT_1_19_3) {
            writePublicKey(publicKey, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_1) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_2) {
                writeUUID(uuid, buf);
            } else {
                if (uuid != null) {
                    buf.writeBoolean(true);
                    writeUUID(uuid, buf);
                } else {
                    buf.writeBoolean(false);
                }
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getData() {
        return this.data;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PlayerPublicKey getPublicKey() {
        return this.publicKey;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setData(final String data) {
        this.data = data;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPublicKey(final PlayerPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUuid(final UUID uuid) {
        this.uuid = uuid;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LoginRequest(data=" + this.getData() + ", publicKey=" + this.getPublicKey() + ", uuid=" + this.getUuid() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LoginRequest() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LoginRequest(final String data, final PlayerPublicKey publicKey, final UUID uuid) {
        this.data = data;
        this.publicKey = publicKey;
        this.uuid = uuid;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LoginRequest)) return false;
        final LoginRequest other = (LoginRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$data = this.getData();
        final java.lang.Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        final java.lang.Object this$publicKey = this.getPublicKey();
        final java.lang.Object other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) return false;
        final java.lang.Object this$uuid = this.getUuid();
        final java.lang.Object other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LoginRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        final java.lang.Object $publicKey = this.getPublicKey();
        result = result * PRIME + ($publicKey == null ? 43 : $publicKey.hashCode());
        final java.lang.Object $uuid = this.getUuid();
        result = result * PRIME + ($uuid == null ? 43 : $uuid.hashCode());
        return result;
    }
}
