// Generated by delombok at Sat Oct 04 04:46:56 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.OverflowPacketException;

public class LoginPayloadResponse extends DefinedPacket {
    private int id;
    private byte[] data;

    @Override
    public void read(ByteBuf buf) {
        id = readVarInt(buf);
        if (buf.readBoolean()) {
            int len = buf.readableBytes();
            if (len > 1048576) {
                throw new OverflowPacketException("Payload may not be larger than 1048576 bytes");
            }
            data = new byte[len];
            buf.readBytes(data);
        }
    }

    @Override
    public void write(ByteBuf buf) {
        writeVarInt(id, buf);
        if (data != null) {
            buf.writeBoolean(true);
            buf.writeBytes(data);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getId() {
        return this.id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getData() {
        return this.data;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setId(final int id) {
        this.id = id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setData(final byte[] data) {
        this.data = data;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LoginPayloadResponse(id=" + this.getId() + ", data=" + java.util.Arrays.toString(this.getData()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LoginPayloadResponse() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LoginPayloadResponse(final int id, final byte[] data) {
        this.id = id;
        this.data = data;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LoginPayloadResponse)) return false;
        final LoginPayloadResponse other = (LoginPayloadResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getId() != other.getId()) return false;
        if (!java.util.Arrays.equals(this.getData(), other.getData())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LoginPayloadResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getId();
        result = result * PRIME + java.util.Arrays.hashCode(this.getData());
        return result;
    }
}
