// Generated by delombok at Sat Oct 04 04:47:58 UTC 2025
package net.md_5.bungee.util;

public class PacketLimiter {
    // max amount of packets allowed per second
    private final int limit;
    // max amount of data allowed per second
    private final int dataLimit;
    private int counter;
    private int dataCounter;
    private long nextSecond;

    /**
     * Counts the received packet amount and size.
     *
     * @param size size of the packet
     * @return return false if the player should be kicked
     */
    public boolean incrementAndCheck(int size) {
        counter++;
        dataCounter += size;
        if ((limit > 0 && counter > limit) || (dataLimit > 0 && dataCounter > dataLimit)) {
            long now = System.currentTimeMillis();
            if (nextSecond > now) {
                return false;
            }
            nextSecond = now + 1000;
            counter = 0;
            dataCounter = 0;
        }
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PacketLimiter(final int limit, final int dataLimit) {
        this.limit = limit;
        this.dataLimit = dataLimit;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getCounter() {
        return this.counter;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getDataCounter() {
        return this.dataCounter;
    }
}
