// Generated by delombok at Sat Oct 04 04:47:58 UTC 2025
package net.md_5.bungee.entitymap;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;

class EntityMap_1_16_2 extends EntityMap {
    static final EntityMap_1_16_2 INSTANCE_1_16_2 = new EntityMap_1_16_2(4, 45);
    static final EntityMap_1_16_2 INSTANCE_1_17 = new EntityMap_1_16_2(4, 45);
    static final EntityMap_1_16_2 INSTANCE_1_18 = new EntityMap_1_16_2(4, 45);
    static final EntityMap_1_16_2 INSTANCE_1_19 = new EntityMap_1_16_2(2, 47);
    static final EntityMap_1_16_2 INSTANCE_1_19_1 = new EntityMap_1_16_2(2, 48);
    static final EntityMap_1_16_2 INSTANCE_1_19_4 = new EntityMap_1_16_2(3, 48);
    //
    private final int spawnPlayerId;
    private final int spectateId;

    @Override
    public void rewriteClientbound(ByteBuf packet, int oldId, int newId, int protocolVersion) {
        if (spawnPlayerId == -1) {
            return;
        }
        // Special cases
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == spawnPlayerId) {
            DefinedPacket.readVarInt(packet); // Entity ID
            int idLength = packet.readerIndex() - readerIndex - packetIdLength;
            UUID uuid = DefinedPacket.readUUID(packet);
            UserConnection player;
            if ((player = BungeeCord.getInstance().getPlayerByOfflineUUID(uuid)) != null) {
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength + idLength);
                DefinedPacket.writeUUID(player.getRewriteId(), packet);
                packet.writerIndex(previous);
            }
        }
        packet.readerIndex(readerIndex);
    }

    @Override
    public void rewriteServerbound(ByteBuf packet, int oldId, int newId) {
        // Special cases
        int readerIndex = packet.readerIndex();
        int packetId = DefinedPacket.readVarInt(packet);
        int packetIdLength = packet.readerIndex() - readerIndex;
        if (packetId == spectateId) {
            UUID uuid = DefinedPacket.readUUID(packet);
            ProxiedPlayer player;
            if ((player = BungeeCord.getInstance().getPlayer(uuid)) != null) {
                int previous = packet.writerIndex();
                packet.readerIndex(readerIndex);
                packet.writerIndex(readerIndex + packetIdLength);
                DefinedPacket.writeUUID(((UserConnection) player).getRewriteId(), packet);
                packet.writerIndex(previous);
            }
        }
        packet.readerIndex(readerIndex);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private EntityMap_1_16_2(final int spawnPlayerId, final int spectateId) {
        this.spawnPlayerId = spawnPlayerId;
        this.spectateId = spectateId;
    }
}
