/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import lombok.Generated;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.ChatSerializer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.util.Either;
import net.md_5.bungee.protocol.util.TagUtil;

public class ShowDialog
extends DefinedPacket {
    protected Either<Integer, Dialog> dialog;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int id = ShowDialog.readVarInt(buf);
        this.dialog = id == 0 ? Either.right(ShowDialog.readDialog(buf, direction, protocolVersion)) : Either.left(id);
    }

    protected static Dialog readDialog(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        TypedTag nbt = (TypedTag)ShowDialog.readTag(buf, protocolVersion);
        JsonElement json = TagUtil.toJson(nbt);
        return ChatSerializer.forVersion(protocolVersion).getDialogSerializer().deserialize(json);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (this.dialog.isLeft()) {
            ShowDialog.writeVarInt(this.dialog.getLeft(), buf);
        } else {
            ShowDialog.writeVarInt(0, buf);
            ShowDialog.writeDialog(this.dialog.getRight(), buf, direction, protocolVersion);
        }
    }

    protected static void writeDialog(Dialog dialog, ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        JsonElement json = ChatSerializer.forVersion(protocolVersion).getDialogSerializer().toJson(dialog);
        TypedTag nbt = TagUtil.fromJson(json);
        ShowDialog.writeTag(nbt, buf, protocolVersion);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public Either<Integer, Dialog> getDialog() {
        return this.dialog;
    }

    @Generated
    public void setDialog(Either<Integer, Dialog> dialog) {
        this.dialog = dialog;
    }

    @Override
    @Generated
    public String toString() {
        return "ShowDialog(dialog=" + this.getDialog() + ")";
    }

    @Generated
    public ShowDialog() {
    }

    @Generated
    public ShowDialog(Either<Integer, Dialog> dialog) {
        this.dialog = dialog;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShowDialog)) {
            return false;
        }
        ShowDialog other = (ShowDialog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Either<Integer, Dialog> this$dialog = this.getDialog();
        Either<Integer, Dialog> other$dialog = other.getDialog();
        return !(this$dialog == null ? other$dialog != null : !((Object)this$dialog).equals(other$dialog));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShowDialog;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Either<Integer, Dialog> $dialog = this.getDialog();
        result = result * 59 + ($dialog == null ? 43 : ((Object)$dialog).hashCode());
        return result;
    }
}

