// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api.score;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Scoreboard {
    /**
     * Unique name for this scoreboard.
     */
    private String name;
    /**
     * Position of this scoreboard.
     */
    private Position position;
    /**
     * Objectives for this scoreboard.
     */
    private final Map<String, Objective> objectives = new HashMap<>();
    /**
     * Scores for this scoreboard.
     */
    private final Map<String, Score> scores = new HashMap<>();
    /**
     * Teams on this board.
     */
    private final Map<String, Team> teams = new HashMap<>();

    public Collection<Objective> getObjectives() {
        return Collections.unmodifiableCollection(objectives.values());
    }

    public Collection<Score> getScores() {
        return Collections.unmodifiableCollection(scores.values());
    }

    public Collection<Team> getTeams() {
        return Collections.unmodifiableCollection(teams.values());
    }

    public void addObjective(Objective objective) {
        Preconditions.checkNotNull(objective, "objective");
        Preconditions.checkArgument(!objectives.containsKey(objective.getName()), "Objective %s already exists in this scoreboard", objective.getName());
        objectives.put(objective.getName(), objective);
    }

    public void addScore(Score score) {
        Preconditions.checkNotNull(score, "score");
        scores.put(score.getItemName(), score);
    }

    public Score getScore(String name) {
        return scores.get(name);
    }

    public void addTeam(Team team) {
        Preconditions.checkNotNull(team, "team");
        Preconditions.checkArgument(!teams.containsKey(team.getName()), "Team %s already exists in this scoreboard", team.getName());
        teams.put(team.getName(), team);
    }

    public Team getTeam(String name) {
        return teams.get(name);
    }

    public Objective getObjective(String name) {
        return objectives.get(name);
    }

    public void removeObjective(String objectiveName) {
        objectives.remove(objectiveName);
    }

    public void removeScore(String scoreName) {
        scores.remove(scoreName);
    }

    public void removeTeam(String teamName) {
        teams.remove(teamName);
    }

    public void clear() {
        name = null;
        position = null;
        objectives.clear();
        scores.clear();
        teams.clear();
    }

    /**
     * Unique name for this scoreboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Position of this scoreboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Position getPosition() {
        return this.position;
    }

    /**
     * Unique name for this scoreboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * Position of this scoreboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPosition(final Position position) {
        this.position = position;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Scoreboard)) return false;
        final Scoreboard other = (Scoreboard) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$position = this.getPosition();
        final java.lang.Object other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) return false;
        final java.lang.Object this$objectives = this.getObjectives();
        final java.lang.Object other$objectives = other.getObjectives();
        if (this$objectives == null ? other$objectives != null : !this$objectives.equals(other$objectives)) return false;
        final java.lang.Object this$scores = this.getScores();
        final java.lang.Object other$scores = other.getScores();
        if (this$scores == null ? other$scores != null : !this$scores.equals(other$scores)) return false;
        final java.lang.Object this$teams = this.getTeams();
        final java.lang.Object other$teams = other.getTeams();
        if (this$teams == null ? other$teams != null : !this$teams.equals(other$teams)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Scoreboard;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $position = this.getPosition();
        result = result * PRIME + ($position == null ? 43 : $position.hashCode());
        final java.lang.Object $objectives = this.getObjectives();
        result = result * PRIME + ($objectives == null ? 43 : $objectives.hashCode());
        final java.lang.Object $scores = this.getScores();
        result = result * PRIME + ($scores == null ? 43 : $scores.hashCode());
        final java.lang.Object $teams = this.getTeams();
        result = result * PRIME + ($teams == null ? 43 : $teams.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Scoreboard(name=" + this.getName() + ", position=" + this.getPosition() + ", objectives=" + this.getObjectives() + ", scores=" + this.getScores() + ", teams=" + this.getTeams() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Scoreboard() {
    }
}
