// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api.event;

import java.util.List;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.plugin.Cancellable;

/**
 * Event called when a backend server sends a response to a player asking to
 * tab-complete a chat message or command. Note that this is not called when
 * BungeeCord or a plugin responds to a tab-complete request. Use
 * {@link TabCompleteEvent} for that.
 */
public class TabCompleteResponseEvent extends TargetedEvent implements Cancellable {
    /**
     * Whether the event is cancelled.
     */
    private boolean cancelled;
    /**
     * Mutable list of suggestions sent back to the player. If this list is
     * empty, an empty list is sent back to the client.
     */
    private final List<String> suggestions;

    public TabCompleteResponseEvent(Connection sender, Connection receiver, List<String> suggestions) {
        super(sender, receiver);
        this.suggestions = suggestions;
    }

    /**
     * Whether the event is cancelled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    /**
     * Mutable list of suggestions sent back to the player. If this list is
     * empty, an empty list is sent back to the client.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getSuggestions() {
        return this.suggestions;
    }

    /**
     * Whether the event is cancelled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancelled(final boolean cancelled) {
        this.cancelled = cancelled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TabCompleteResponseEvent(super=" + super.toString() + ", cancelled=" + this.isCancelled() + ", suggestions=" + this.getSuggestions() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TabCompleteResponseEvent)) return false;
        final TabCompleteResponseEvent other = (TabCompleteResponseEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        if (this.isCancelled() != other.isCancelled()) return false;
        final java.lang.Object this$suggestions = this.getSuggestions();
        final java.lang.Object other$suggestions = other.getSuggestions();
        if (this$suggestions == null ? other$suggestions != null : !this$suggestions.equals(other$suggestions)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TabCompleteResponseEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + (this.isCancelled() ? 79 : 97);
        final java.lang.Object $suggestions = this.getSuggestions();
        result = result * PRIME + ($suggestions == null ? 43 : $suggestions.hashCode());
        return result;
    }
}
