// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api.event;

import lombok.NonNull;
import net.md_5.bungee.api.ServerConnectRequest;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Cancellable;
import net.md_5.bungee.api.plugin.Event;

/**
 * Called when deciding to connect to a server. At the time when this event is
 * called, no connection has actually been made. Cancelling the event will
 * ensure that the connection does not proceed and can be useful to prevent
 * certain players from accessing certain servers.
 */
public class ServerConnectEvent extends Event implements Cancellable {
    /**
     * Player connecting to a new server.
     */
    private final ProxiedPlayer player;
    /**
     * Server the player will be connected to.
     */
    @NonNull
    private ServerInfo target;
    /**
     * Reason for connecting to a new server.
     */
    private final Reason reason;
    /**
     * Request used to connect to given server.
     */
    private final ServerConnectRequest request;
    /**
     * Cancelled state.
     */
    private boolean cancelled;

    @Deprecated
    public ServerConnectEvent(ProxiedPlayer player, ServerInfo target) {
        this(player, target, Reason.UNKNOWN);
    }

    @Deprecated
    public ServerConnectEvent(ProxiedPlayer player, ServerInfo target, Reason reason) {
        this(player, target, reason, null);
    }

    public ServerConnectEvent(ProxiedPlayer player, ServerInfo target, Reason reason, ServerConnectRequest request) {
        this.player = player;
        this.target = target;
        this.reason = reason;
        this.request = request;
    }


    public enum Reason {
        /**
         * Redirection to lobby server due to being unable to connect to
         * original server
         */
        LOBBY_FALLBACK, /**
         * Execution of a command
         */
        COMMAND, /**
         * Redirecting to another server when client loses connection to server
         * due to an exception.
         */
        SERVER_DOWN_REDIRECT, /**
         * Redirecting to another server when kicked from original server.
         */
        KICK_REDIRECT, /**
         * Plugin message request.
         */
        PLUGIN_MESSAGE, /**
         * Initial proxy connect.
         */
        JOIN_PROXY, /**
         * Plugin initiated connect.
         */
        PLUGIN, /**
         * Unknown cause.
         */
        UNKNOWN;
    }

    /**
     * Player connecting to a new server.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProxiedPlayer getPlayer() {
        return this.player;
    }

    /**
     * Server the player will be connected to.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerInfo getTarget() {
        return this.target;
    }

    /**
     * Reason for connecting to a new server.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Reason getReason() {
        return this.reason;
    }

    /**
     * Request used to connect to given server.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerConnectRequest getRequest() {
        return this.request;
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    /**
     * Server the player will be connected to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTarget(@NonNull final ServerInfo target) {
        if (target == null) {
            throw new java.lang.NullPointerException("target is marked non-null but is null");
        }
        this.target = target;
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancelled(final boolean cancelled) {
        this.cancelled = cancelled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ServerConnectEvent(player=" + this.getPlayer() + ", target=" + this.getTarget() + ", reason=" + this.getReason() + ", request=" + this.getRequest() + ", cancelled=" + this.isCancelled() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServerConnectEvent)) return false;
        final ServerConnectEvent other = (ServerConnectEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.isCancelled() != other.isCancelled()) return false;
        final java.lang.Object this$player = this.getPlayer();
        final java.lang.Object other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) return false;
        final java.lang.Object this$target = this.getTarget();
        final java.lang.Object other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        final java.lang.Object this$request = this.getRequest();
        final java.lang.Object other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ServerConnectEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + (this.isCancelled() ? 79 : 97);
        final java.lang.Object $player = this.getPlayer();
        result = result * PRIME + ($player == null ? 43 : $player.hashCode());
        final java.lang.Object $target = this.getTarget();
        result = result * PRIME + ($target == null ? 43 : $target.hashCode());
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        final java.lang.Object $request = this.getRequest();
        result = result * PRIME + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}
