// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api.event;

import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.plugin.Cancellable;

/**
 * Event called to represent a player logging in.
 */
public class LoginEvent extends AsyncEvent<LoginEvent> implements Cancellable {
    /**
     * Cancelled state.
     */
    private boolean cancelled;
    /**
     * Message to use when kicking if this event is canceled.
     */
    private BaseComponent reason;
    /**
     * Connection attempting to login.
     */
    private final PendingConnection connection;

    public LoginEvent(PendingConnection connection, Callback<LoginEvent> done) {
        super(done);
        this.connection = connection;
    }

    /**
     * @return reason to be displayed
     * @deprecated use component methods instead
     */
    @Deprecated
    public String getCancelReason() {
        return TextComponent.toLegacyText(getReason());
    }

    /**
     * @param cancelReason reason to be displayed
     * @deprecated use component methods instead
     */
    @Deprecated
    public void setCancelReason(String cancelReason) {
        setReason(TextComponent.fromLegacy(cancelReason));
    }

    /**
     * @return reason to be displayed
     * @deprecated use single component methods instead
     */
    @Deprecated
    public BaseComponent[] getCancelReasonComponents() {
        return new BaseComponent[] {getReason()};
    }

    /**
     * @param cancelReason reason to be displayed
     * @deprecated use single component methods instead
     */
    @Deprecated
    public void setCancelReason(BaseComponent... cancelReason) {
        setReason(TextComponent.fromArray(cancelReason));
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    /**
     * Message to use when kicking if this event is canceled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent getReason() {
        return this.reason;
    }

    /**
     * Connection attempting to login.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PendingConnection getConnection() {
        return this.connection;
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancelled(final boolean cancelled) {
        this.cancelled = cancelled;
    }

    /**
     * Message to use when kicking if this event is canceled.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setReason(final BaseComponent reason) {
        this.reason = reason;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "LoginEvent(cancelled=" + this.isCancelled() + ", reason=" + this.getReason() + ", connection=" + this.getConnection() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LoginEvent)) return false;
        final LoginEvent other = (LoginEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.isCancelled() != other.isCancelled()) return false;
        final java.lang.Object this$reason = this.getReason();
        final java.lang.Object other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
        final java.lang.Object this$connection = this.getConnection();
        final java.lang.Object other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof LoginEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + (this.isCancelled() ? 79 : 97);
        final java.lang.Object $reason = this.getReason();
        result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
        final java.lang.Object $connection = this.getConnection();
        result = result * PRIME + ($connection == null ? 43 : $connection.hashCode());
        return result;
    }
}
