// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api.event;

import com.google.gson.JsonElement;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Cancellable;
import net.md_5.bungee.api.plugin.Event;
import org.jetbrains.annotations.ApiStatus;

/**
 * Called after a {@link ProxiedPlayer} runs a custom action from a chat event
 * or form submission.
 */
@ApiStatus.Experimental
public class CustomClickEvent extends Event implements Cancellable {
    /**
     * Player who clicked.
     */
    private final ProxiedPlayer player;
    /**
     * Custom action ID.
     */
    private final String id;
    /**
     * The data as submitted.
     */
    private final JsonElement data;
    /**
     * Cancelled state.
     */
    private boolean cancelled;

    /**
     * Creates a new {@code CustomClickEvent} instance.
     *
     * @param player Player who clicked.
     * @param id Custom action ID.
     * @param data The data as submitted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CustomClickEvent(final ProxiedPlayer player, final String id, final JsonElement data) {
        this.player = player;
        this.id = id;
        this.data = data;
    }

    /**
     * Player who clicked.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ProxiedPlayer getPlayer() {
        return this.player;
    }

    /**
     * Custom action ID.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getId() {
        return this.id;
    }

    /**
     * The data as submitted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public JsonElement getData() {
        return this.data;
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancelled(final boolean cancelled) {
        this.cancelled = cancelled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CustomClickEvent(player=" + this.getPlayer() + ", id=" + this.getId() + ", data=" + this.getData() + ", cancelled=" + this.isCancelled() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CustomClickEvent)) return false;
        final CustomClickEvent other = (CustomClickEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.isCancelled() != other.isCancelled()) return false;
        final java.lang.Object this$player = this.getPlayer();
        final java.lang.Object other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$data = this.getData();
        final java.lang.Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CustomClickEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + (this.isCancelled() ? 79 : 97);
        final java.lang.Object $player = this.getPlayer();
        result = result * PRIME + ($player == null ? 43 : $player.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $data = this.getData();
        result = result * PRIME + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}
