// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api.event;

import java.net.SocketAddress;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.plugin.Cancellable;
import net.md_5.bungee.api.plugin.Event;

/**
 * Event called to represent an initial client connection.
 * <br>
 * Note: This event is called at an early stage of every connection, handling
 * should be <b>fast</b>.
 */
public class ClientConnectEvent extends Event implements Cancellable {
    /**
     * Cancelled state.
     */
    private boolean cancelled;
    /**
     * Remote address of connection.
     */
    private final SocketAddress socketAddress;
    /**
     * Listener that accepted the connection.
     */
    private final ListenerInfo listener;

    /**
     * Creates a new {@code ClientConnectEvent} instance.
     *
     * @param socketAddress Remote address of connection.
     * @param listener Listener that accepted the connection.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClientConnectEvent(final SocketAddress socketAddress, final ListenerInfo listener) {
        this.socketAddress = socketAddress;
        this.listener = listener;
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    /**
     * Remote address of connection.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    /**
     * Listener that accepted the connection.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ListenerInfo getListener() {
        return this.listener;
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancelled(final boolean cancelled) {
        this.cancelled = cancelled;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ClientConnectEvent(cancelled=" + this.isCancelled() + ", socketAddress=" + this.getSocketAddress() + ", listener=" + this.getListener() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ClientConnectEvent)) return false;
        final ClientConnectEvent other = (ClientConnectEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.isCancelled() != other.isCancelled()) return false;
        final java.lang.Object this$socketAddress = this.getSocketAddress();
        final java.lang.Object other$socketAddress = other.getSocketAddress();
        if (this$socketAddress == null ? other$socketAddress != null : !this$socketAddress.equals(other$socketAddress)) return false;
        final java.lang.Object this$listener = this.getListener();
        final java.lang.Object other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ClientConnectEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + (this.isCancelled() ? 79 : 97);
        final java.lang.Object $socketAddress = this.getSocketAddress();
        result = result * PRIME + ($socketAddress == null ? 43 : $socketAddress.hashCode());
        final java.lang.Object $listener = this.getListener();
        result = result * PRIME + ($listener == null ? 43 : $listener.hashCode());
        return result;
    }
}
