// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api.event;

import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.plugin.Cancellable;
import net.md_5.bungee.api.plugin.PluginManager;

/**
 * Event called when a player sends a message to a server.
 */
public class ChatEvent extends TargetedEvent implements Cancellable {
    /**
     * Cancelled state.
     */
    private boolean cancelled;
    /**
     * Text contained in this chat.
     */
    private String message;

    public ChatEvent(Connection sender, Connection receiver, String message) {
        super(sender, receiver);
        this.message = message;
    }

    /**
     * Checks whether this message is valid as a command
     *
     * @return if this message is a command
     */
    public boolean isCommand() {
        return message.length() > 0 && message.charAt(0) == '/';
    }

    /**
     * Checks whether this message is run on this proxy server.
     *
     * @return if this command runs on the proxy
     * @see PluginManager#isExecutableCommand(java.lang.String,
     * net.md_5.bungee.api.CommandSender)
     */
    public boolean isProxyCommand() {
        if (!isCommand()) {
            return false;
        }
        int index = message.indexOf(" ");
        String commandName = (index == -1) ? message.substring(1) : message.substring(1, index);
        CommandSender sender = (getSender() instanceof CommandSender) ? (CommandSender) getSender() : null;
        return ProxyServer.getInstance().getPluginManager().isExecutableCommand(commandName, sender);
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    /**
     * Text contained in this chat.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * Cancelled state.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCancelled(final boolean cancelled) {
        this.cancelled = cancelled;
    }

    /**
     * Text contained in this chat.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMessage(final String message) {
        this.message = message;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ChatEvent(super=" + super.toString() + ", cancelled=" + this.isCancelled() + ", message=" + this.getMessage() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ChatEvent)) return false;
        final ChatEvent other = (ChatEvent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        if (this.isCancelled() != other.isCancelled()) return false;
        final java.lang.Object this$message = this.getMessage();
        final java.lang.Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ChatEvent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + (this.isCancelled() ? 79 : 97);
        final java.lang.Object $message = this.getMessage();
        result = result * PRIME + ($message == null ? 43 : $message.hashCode());
        return result;
    }
}
