// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;

/**
 * Represents the standard list data returned by opening a server in the
 * Minecraft client server list, or hitting it with a packet 0xFE.
 */
public class ServerPing {
    private Protocol version;


    public static class Protocol {
        private String name;
        private int protocol;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int getProtocol() {
            return this.protocol;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setName(final String name) {
            this.name = name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setProtocol(final int protocol) {
            this.protocol = protocol;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ServerPing.Protocol)) return false;
            final ServerPing.Protocol other = (ServerPing.Protocol) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (this.getProtocol() != other.getProtocol()) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ServerPing.Protocol;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            result = result * PRIME + this.getProtocol();
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ServerPing.Protocol(name=" + this.getName() + ", protocol=" + this.getProtocol() + ")";
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Protocol(final String name, final int protocol) {
            this.name = name;
            this.protocol = protocol;
        }
    }

    private Players players;


    public static class Players {
        private int max;
        private int online;
        private PlayerInfo[] sample;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int getMax() {
            return this.max;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int getOnline() {
            return this.online;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PlayerInfo[] getSample() {
            return this.sample;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setMax(final int max) {
            this.max = max;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setOnline(final int online) {
            this.online = online;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setSample(final PlayerInfo[] sample) {
            this.sample = sample;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ServerPing.Players)) return false;
            final ServerPing.Players other = (ServerPing.Players) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (this.getMax() != other.getMax()) return false;
            if (this.getOnline() != other.getOnline()) return false;
            if (!java.util.Arrays.deepEquals(this.getSample(), other.getSample())) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ServerPing.Players;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            result = result * PRIME + this.getMax();
            result = result * PRIME + this.getOnline();
            result = result * PRIME + java.util.Arrays.deepHashCode(this.getSample());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ServerPing.Players(max=" + this.getMax() + ", online=" + this.getOnline() + ", sample=" + java.util.Arrays.deepToString(this.getSample()) + ")";
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Players(final int max, final int online, final PlayerInfo[] sample) {
            this.max = max;
            this.online = online;
            this.sample = sample;
        }
    }


    public static class PlayerInfo {
        private String name;
        private UUID uniqueId;
        private static final UUID md5UUID = Util.getUUID("af74a02d19cb445bb07f6866a861f783");

        public PlayerInfo(String name, String id) {
            setName(name);
            setId(id);
        }

        public void setId(String id) {
            try {
                uniqueId = Util.getUUID(id);
            } catch (Exception e) {
                // Fallback on a valid uuid otherwise Minecraft complains
                uniqueId = md5UUID;
            }
        }

        public String getId() {
            return uniqueId.toString().replace("-", "");
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getName() {
            return this.name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public UUID getUniqueId() {
            return this.uniqueId;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setName(final String name) {
            this.name = name;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setUniqueId(final UUID uniqueId) {
            this.uniqueId = uniqueId;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ServerPing.PlayerInfo)) return false;
            final ServerPing.PlayerInfo other = (ServerPing.PlayerInfo) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$uniqueId = this.getUniqueId();
            final java.lang.Object other$uniqueId = other.getUniqueId();
            if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ServerPing.PlayerInfo;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $uniqueId = this.getUniqueId();
            result = result * PRIME + ($uniqueId == null ? 43 : $uniqueId.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ServerPing.PlayerInfo(name=" + this.getName() + ", uniqueId=" + this.getUniqueId() + ")";
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public PlayerInfo(final String name, final UUID uniqueId) {
            this.name = name;
            this.uniqueId = uniqueId;
        }
    }

    private BaseComponent description;
    private Favicon favicon;


    public static class ModInfo {
        private String type = "FML";
        private List<ModItem> modList = new ArrayList<>();

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ModInfo() {
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getType() {
            return this.type;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public List<ModItem> getModList() {
            return this.modList;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setType(final String type) {
            this.type = type;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setModList(final List<ModItem> modList) {
            this.modList = modList;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ServerPing.ModInfo)) return false;
            final ServerPing.ModInfo other = (ServerPing.ModInfo) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$type = this.getType();
            final java.lang.Object other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
            final java.lang.Object this$modList = this.getModList();
            final java.lang.Object other$modList = other.getModList();
            if (this$modList == null ? other$modList != null : !this$modList.equals(other$modList)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ServerPing.ModInfo;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $type = this.getType();
            result = result * PRIME + ($type == null ? 43 : $type.hashCode());
            final java.lang.Object $modList = this.getModList();
            result = result * PRIME + ($modList == null ? 43 : $modList.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ServerPing.ModInfo(type=" + this.getType() + ", modList=" + this.getModList() + ")";
        }
    }


    public static class ModItem {
        private String modid;
        private String version;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getModid() {
            return this.modid;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getVersion() {
            return this.version;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setModid(final String modid) {
            this.modid = modid;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public void setVersion(final String version) {
            this.version = version;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ServerPing.ModItem)) return false;
            final ServerPing.ModItem other = (ServerPing.ModItem) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$modid = this.getModid();
            final java.lang.Object other$modid = other.getModid();
            if (this$modid == null ? other$modid != null : !this$modid.equals(other$modid)) return false;
            final java.lang.Object this$version = this.getVersion();
            final java.lang.Object other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ServerPing.ModItem;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $modid = this.getModid();
            result = result * PRIME + ($modid == null ? 43 : $modid.hashCode());
            final java.lang.Object $version = this.getVersion();
            result = result * PRIME + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ServerPing.ModItem(modid=" + this.getModid() + ", version=" + this.getVersion() + ")";
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ModItem(final String modid, final String version) {
            this.modid = modid;
            this.version = version;
        }
    }

    // Right now, we don't get the mods from the user, so we just use a stock ModInfo object to
    // create the server ping. Vanilla clients will ignore this.
    private final ModInfo modinfo = new ModInfo();

    @Deprecated
    public ServerPing(Protocol version, Players players, String description, String favicon) {
        this(version, players, TextComponent.fromLegacy(description), favicon == null ? null : Favicon.create(favicon));
    }

    @Deprecated
    public ServerPing(Protocol version, Players players, String description, Favicon favicon) {
        this(version, players, TextComponent.fromLegacy(description), favicon);
    }

    @Deprecated
    public String getFavicon() {
        return getFaviconObject() == null ? null : getFaviconObject().getEncoded();
    }

    public Favicon getFaviconObject() {
        return this.favicon;
    }

    @Deprecated
    public void setFavicon(String favicon) {
        setFavicon(favicon == null ? null : Favicon.create(favicon));
    }

    public void setFavicon(Favicon favicon) {
        this.favicon = favicon;
    }

    @Deprecated
    public void setDescription(String description) {
        this.description = TextComponent.fromLegacy(description);
    }

    @Deprecated
    public String getDescription() {
        return BaseComponent.toLegacyText(description);
    }

    public void setDescriptionComponent(BaseComponent description) {
        this.description = description;
    }

    public BaseComponent getDescriptionComponent() {
        return description;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Protocol getVersion() {
        return this.version;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Players getPlayers() {
        return this.players;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ModInfo getModinfo() {
        return this.modinfo;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVersion(final Protocol version) {
        this.version = version;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPlayers(final Players players) {
        this.players = players;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServerPing)) return false;
        final ServerPing other = (ServerPing) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        final java.lang.Object this$players = this.getPlayers();
        final java.lang.Object other$players = other.getPlayers();
        if (this$players == null ? other$players != null : !this$players.equals(other$players)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$favicon = this.getFavicon();
        final java.lang.Object other$favicon = other.getFavicon();
        if (this$favicon == null ? other$favicon != null : !this$favicon.equals(other$favicon)) return false;
        final java.lang.Object this$modinfo = this.getModinfo();
        final java.lang.Object other$modinfo = other.getModinfo();
        if (this$modinfo == null ? other$modinfo != null : !this$modinfo.equals(other$modinfo)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ServerPing;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        final java.lang.Object $players = this.getPlayers();
        result = result * PRIME + ($players == null ? 43 : $players.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $favicon = this.getFavicon();
        result = result * PRIME + ($favicon == null ? 43 : $favicon.hashCode());
        final java.lang.Object $modinfo = this.getModinfo();
        result = result * PRIME + ($modinfo == null ? 43 : $modinfo.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ServerPing(version=" + this.getVersion() + ", players=" + this.getPlayers() + ", description=" + this.getDescription() + ", modinfo=" + this.getModinfo() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerPing() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerPing(final Protocol version, final Players players, final BaseComponent description, final Favicon favicon) {
        this.version = version;
        this.players = players;
        this.description = description;
        this.favicon = favicon;
    }
}
