// Generated by delombok at Sat Oct 04 04:47:10 UTC 2025
package net.md_5.bungee.api;

import lombok.NonNull;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ServerConnectEvent;

/**
 * A request to connect a server.
 */
public class ServerConnectRequest {

    /**
     * The result from this callback after request has been executed by proxy.
     */
    public enum Result {
        /**
         * ServerConnectEvent to the new server was canceled.
         */
        EVENT_CANCEL, /**
         * Already connected to target server.
         */
        ALREADY_CONNECTED, /**
         * Already connecting to target server.
         */
        ALREADY_CONNECTING, /**
         * Successfully connected to server.
         */
        SUCCESS, /**
         * Connection failed, error can be accessed from callback method handle.
         */
        FAIL;
    }

    /**
     * Target server to connect to.
     */
    @NonNull
    private final ServerInfo target;
    /**
     * Reason for connecting to server.
     */
    @NonNull
    private final ServerConnectEvent.Reason reason;
    /**
     * Callback to execute post request.
     */
    private final Callback<Result> callback;
    /**
     * Timeout in milliseconds for request.
     */
    private int connectTimeout;
    /**
     * Should the player be attempted to connect to the next server in their
     * queue if the initial request fails.
     */
    private boolean retry;


    /**
     * Class that sets default properties/adds methods to the lombok builder
     * generated class.
     */
    public static class Builder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ServerInfo target;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ServerConnectEvent.Reason reason;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Callback<Result> callback;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean retry;
        private int connectTimeout = ProxyServer.getInstance().getConfig().getServerConnectTimeout();

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        Builder() {
        }

        /**
         * Target server to connect to.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ServerConnectRequest.Builder target(@NonNull final ServerInfo target) {
            if (target == null) {
                throw new java.lang.NullPointerException("target is marked non-null but is null");
            }
            this.target = target;
            return this;
        }

        /**
         * Reason for connecting to server.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ServerConnectRequest.Builder reason(@NonNull final ServerConnectEvent.Reason reason) {
            if (reason == null) {
                throw new java.lang.NullPointerException("reason is marked non-null but is null");
            }
            this.reason = reason;
            return this;
        }

        /**
         * Callback to execute post request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ServerConnectRequest.Builder callback(final Callback<Result> callback) {
            this.callback = callback;
            return this;
        }

        /**
         * Timeout in milliseconds for request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ServerConnectRequest.Builder connectTimeout(final int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        /**
         * Should the player be attempted to connect to the next server in their
         * queue if the initial request fails.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ServerConnectRequest.Builder retry(final boolean retry) {
            this.retry = retry;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public ServerConnectRequest build() {
            return new ServerConnectRequest(this.target, this.reason, this.callback, this.connectTimeout, this.retry);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ServerConnectRequest.Builder(target=" + this.target + ", reason=" + this.reason + ", callback=" + this.callback + ", connectTimeout=" + this.connectTimeout + ", retry=" + this.retry + ")";
        }
    }

    /**
     * Creates a new {@code ServerConnectRequest} instance.
     *
     * @param target Target server to connect to.
     * @param reason Reason for connecting to server.
     * @param callback Callback to execute post request.
     * @param connectTimeout Timeout in milliseconds for request.
     * @param retry Should the player be attempted to connect to the next server in their
     * queue if the initial request fails.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    ServerConnectRequest(@NonNull final ServerInfo target, @NonNull final ServerConnectEvent.Reason reason, final Callback<Result> callback, final int connectTimeout, final boolean retry) {
        if (target == null) {
            throw new java.lang.NullPointerException("target is marked non-null but is null");
        }
        if (reason == null) {
            throw new java.lang.NullPointerException("reason is marked non-null but is null");
        }
        this.target = target;
        this.reason = reason;
        this.callback = callback;
        this.connectTimeout = connectTimeout;
        this.retry = retry;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ServerConnectRequest.Builder builder() {
        return new ServerConnectRequest.Builder();
    }

    /**
     * Target server to connect to.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerInfo getTarget() {
        return this.target;
    }

    /**
     * Reason for connecting to server.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerConnectEvent.Reason getReason() {
        return this.reason;
    }

    /**
     * Callback to execute post request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Callback<Result> getCallback() {
        return this.callback;
    }

    /**
     * Timeout in milliseconds for request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    /**
     * Should the player be attempted to connect to the next server in their
     * queue if the initial request fails.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isRetry() {
        return this.retry;
    }

    /**
     * Timeout in milliseconds for request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setConnectTimeout(final int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /**
     * Should the player be attempted to connect to the next server in their
     * queue if the initial request fails.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setRetry(final boolean retry) {
        this.retry = retry;
    }
}
