/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.jni.cipher;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import lombok.Generated;
import net.md_5.bungee.jni.cipher.BungeeCipher;
import net.md_5.bungee.jni.cipher.NativeCipherImpl;

public class NativeCipher
implements BungeeCipher {
    private final NativeCipherImpl nativeCipher = new NativeCipherImpl();
    private long ctx;

    @Override
    public void init(boolean forEncryption, SecretKey key) throws GeneralSecurityException {
        Preconditions.checkArgument((key.getEncoded().length == 16 ? 1 : 0) != 0, (Object)"Invalid key size");
        this.free();
        this.ctx = this.nativeCipher.init(forEncryption, key.getEncoded());
    }

    @Override
    public void free() {
        if (this.ctx != 0L) {
            this.nativeCipher.free(this.ctx);
            this.ctx = 0L;
        }
    }

    @Override
    public void cipher(ByteBuf in, ByteBuf out) throws GeneralSecurityException {
        Preconditions.checkState((this.ctx != 0L ? 1 : 0) != 0, (Object)"Invalid pointer to AES key!");
        int length = in.readableBytes();
        if (length <= 0) {
            return;
        }
        out.ensureWritable(length);
        this.nativeCipher.cipher(this.ctx, in.memoryAddress() + (long)in.readerIndex(), out.memoryAddress() + (long)out.writerIndex(), length);
        in.readerIndex(in.writerIndex());
        out.writerIndex(out.writerIndex() + length);
    }

    @Override
    public ByteBuf cipher(ChannelHandlerContext ctx, ByteBuf in) throws GeneralSecurityException {
        int readableBytes = in.readableBytes();
        ByteBuf heapOut = ctx.alloc().directBuffer(readableBytes);
        this.cipher(in, heapOut);
        return heapOut;
    }

    @Override
    public boolean allowComposite() {
        return false;
    }

    @Generated
    public NativeCipherImpl getNativeCipher() {
        return this.nativeCipher;
    }
}

