// Generated by delombok at Sat Oct 04 04:45:27 UTC 2025
package net.md_5.bungee.api.dialog.action;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;

/**
 * Represents a dialog action which will usually appear as a button.
 */
public class ActionButton {
    /**
     * The text label of the button, mandatory.
     */
    @NonNull
    private BaseComponent label;
    /**
     * The hover tooltip of the button.
     */
    private BaseComponent tooltip;
    /**
     * The width of the button (default: 150, minimum: 1, maximum: 1024).
     */
    private Integer width;
    /**
     * The action to take.
     */
    @NonNull
    private Action action;

    public ActionButton(@NonNull BaseComponent label, BaseComponent tooltip, Integer width, @NonNull Action action) {
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        if (action == null) {
            throw new java.lang.NullPointerException("action is marked non-null but is null");
        }
        this.label = label;
        this.tooltip = tooltip;
        setWidth(width);
        this.action = action;
    }

    public ActionButton(@NonNull BaseComponent label, @NonNull Action action) {
        this(label, null, null, action);
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        if (action == null) {
            throw new java.lang.NullPointerException("action is marked non-null but is null");
        }
    }

    public void setWidth(Integer width) {
        Preconditions.checkArgument(width == null || (width >= 1 && width <= 1024), "width must be between 1 and 1024");
        this.width = width;
    }

    /**
     * The text label of the button, mandatory.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent label() {
        return this.label;
    }

    /**
     * The hover tooltip of the button.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent tooltip() {
        return this.tooltip;
    }

    /**
     * The width of the button (default: 150, minimum: 1, maximum: 1024).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer width() {
        return this.width;
    }

    /**
     * The action to take.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Action action() {
        return this.action;
    }

    /**
     * The text label of the button, mandatory.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ActionButton label(@NonNull final BaseComponent label) {
        if (label == null) {
            throw new java.lang.NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    /**
     * The hover tooltip of the button.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ActionButton tooltip(final BaseComponent tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    /**
     * The width of the button (default: 150, minimum: 1, maximum: 1024).
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ActionButton width(final Integer width) {
        this.width = width;
        return this;
    }

    /**
     * The action to take.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ActionButton action(@NonNull final Action action) {
        if (action == null) {
            throw new java.lang.NullPointerException("action is marked non-null but is null");
        }
        this.action = action;
        return this;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ActionButton)) return false;
        final ActionButton other = (ActionButton) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$width = this.width();
        final java.lang.Object other$width = other.width();
        if (this$width == null ? other$width != null : !this$width.equals(other$width)) return false;
        final java.lang.Object this$label = this.label();
        final java.lang.Object other$label = other.label();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
        final java.lang.Object this$tooltip = this.tooltip();
        final java.lang.Object other$tooltip = other.tooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) return false;
        final java.lang.Object this$action = this.action();
        final java.lang.Object other$action = other.action();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ActionButton;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $width = this.width();
        result = result * PRIME + ($width == null ? 43 : $width.hashCode());
        final java.lang.Object $label = this.label();
        result = result * PRIME + ($label == null ? 43 : $label.hashCode());
        final java.lang.Object $tooltip = this.tooltip();
        result = result * PRIME + ($tooltip == null ? 43 : $tooltip.hashCode());
        final java.lang.Object $action = this.action();
        result = result * PRIME + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ActionButton(label=" + this.label() + ", tooltip=" + this.tooltip() + ", width=" + this.width() + ", action=" + this.action() + ")";
    }
}
