// Generated by delombok at Tue Dec 16 19:34:11 UTC 2025
package net.md_5.bungee.api.chat;

/**
 * This component displays the score based on a player score on the scoreboard.
 * <br>
 * The <b>name</b> is the name of the player stored on the scoreboard, which may
 * be a "fake" player. It can also be a target selector that <b>must</b> resolve
 * to 1 target, and may target non-player entities.
 * <br>
 * With a book, /tellraw, or /title, using the wildcard '*' in the place of a
 * name or target selector will cause all players to see their own score in the
 * specified objective.
 * <br>
 * <b>Signs cannot use the '*' wildcard</b>
 * <br>
 * These values are filled in by the server-side implementation.
 * <br>
 * As of 1.12.2, a bug ( MC-56373 ) prevents full usage within hover events.
 */
public final class ScoreComponent extends BaseComponent {
    /**
     * The name of the entity whose score should be displayed.
     */
    private String name;
    /**
     * The internal name of the objective the score is attached to.
     */
    private String objective;
    /**
     * The optional value to use instead of the one present in the Scoreboard.
     */
    private String value = "";

    /**
     * Creates a new score component with the specified name and objective.<br>
     * If not specifically set, value will default to an empty string;
     * signifying that the scoreboard value should take precedence. If not null,
     * nor empty, {@code value} will override any value found in the
     * scoreboard.<br>
     * The value defaults to an empty string.
     *
     * @param name the name of the entity, or an entity selector, whose score
     * should be displayed
     * @param objective the internal name of the objective the entity's score is
     * attached to
     */
    public ScoreComponent(String name, String objective) {
        setName(name);
        setObjective(objective);
    }

    /**
     * Creates a score component from the original to clone it.
     *
     * @param original the original for the new score component
     */
    public ScoreComponent(ScoreComponent original) {
        super(original);
        setName(original.getName());
        setObjective(original.getObjective());
        setValue(original.getValue());
    }

    @Override
    public ScoreComponent duplicate() {
        return new ScoreComponent(this);
    }

    @Override
    protected void toPlainText(StringVisitor builder) {
        builder.append(this.value);
        super.toPlainText(builder);
    }

    @Override
    protected void toLegacyText(StringVisitor builder) {
        addFormat(builder);
        builder.append(this.value);
        super.toLegacyText(builder);
    }

    /**
     * The name of the entity whose score should be displayed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * The internal name of the objective the score is attached to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getObjective() {
        return this.objective;
    }

    /**
     * The optional value to use instead of the one present in the Scoreboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getValue() {
        return this.value;
    }

    /**
     * The name of the entity whose score should be displayed.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * The internal name of the objective the score is attached to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setObjective(final String objective) {
        this.objective = objective;
    }

    /**
     * The optional value to use instead of the one present in the Scoreboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final String value) {
        this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ScoreComponent(name=" + this.getName() + ", objective=" + this.getObjective() + ", value=" + this.getValue() + ")";
    }

    /**
     * Creates a new {@code ScoreComponent} instance.
     *
     * @param name The name of the entity whose score should be displayed.
     * @param objective The internal name of the objective the score is attached to.
     * @param value The optional value to use instead of the one present in the Scoreboard.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ScoreComponent(final String name, final String objective, final String value) {
        this.name = name;
        this.objective = objective;
        this.value = value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ScoreComponent)) return false;
        final ScoreComponent other = (ScoreComponent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$objective = this.getObjective();
        final java.lang.Object other$objective = other.getObjective();
        if (this$objective == null ? other$objective != null : !this$objective.equals(other$objective)) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ScoreComponent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $objective = this.getObjective();
        result = result * PRIME + ($objective == null ? 43 : $objective.hashCode());
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}
