// Generated by delombok at Fri Nov 21 22:29:51 UTC 2025
package net.md_5.bungee.api.chat;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.chat.TranslationRegistry;

public final class TranslatableComponent extends BaseComponent {
    private static final Pattern FORMAT = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
    /**
     * The key into the Minecraft locale files to use for the translation. The
     * text depends on the client's locale setting. The console is always en_US
     */
    private String translate;
    /**
     * The components to substitute into the translation
     */
    private List<BaseComponent> with;
    /**
     * The fallback, if the translation is not found
     */
    private String fallback;

    /**
     * Creates a translatable component from the original to clone it.
     *
     * @param original the original for the new translatable component.
     */
    public TranslatableComponent(TranslatableComponent original) {
        super(original);
        setTranslate(original.getTranslate());
        setFallback(original.getFallback());
        if (original.getWith() != null) {
            List<BaseComponent> temp = new ArrayList<>();
            for (BaseComponent baseComponent : original.getWith()) {
                temp.add(baseComponent.duplicate());
            }
            setWith(temp);
        }
    }

    /**
     * Creates a translatable component with the passed substitutions
     *
     * @param translate the translation key
     * @param with the {@link java.lang.String}s and
     * {@link net.md_5.bungee.api.chat.BaseComponent}s to use into the
     * translation
     * @see #translate
     * @see #setWith(java.util.List)
     */
    public TranslatableComponent(String translate, Object... with) {
        setTranslate(translate);
        if (with != null && with.length != 0) {
            List<BaseComponent> temp = new ArrayList<BaseComponent>();
            for (Object w : with) {
                if (w instanceof BaseComponent) {
                    temp.add((BaseComponent) w);
                } else {
                    temp.add(new TextComponent(String.valueOf(w)));
                }
            }
            setWith(temp);
        }
    }

    /**
     * Creates a translatable component with the passed substitutions
     *
     * @param translatable the translatable object
     * @param with the {@link java.lang.String}s and
     * {@link net.md_5.bungee.api.chat.BaseComponent}s to use into the
     * translation
     * @see #translate
     * @see #setWith(java.util.List)
     */
    public TranslatableComponent(TranslationProvider translatable, Object... with) {
        this(translatable.getTranslationKey(), with);
    }

    /**
     * Creates a duplicate of this TranslatableComponent.
     *
     * @return the duplicate of this TranslatableComponent.
     */
    @Override
    public TranslatableComponent duplicate() {
        return new TranslatableComponent(this);
    }

    /**
     * Sets the translation substitutions to be used in this component. Removes
     * any previously set substitutions
     *
     * @param components the components to substitute
     */
    public void setWith(List<BaseComponent> components) {
        for (BaseComponent component : components) {
            component.parent = this;
        }
        with = components;
    }

    /**
     * Adds a text substitution to the component. The text will inherit this
     * component's formatting
     *
     * @param text the text to substitute
     */
    public void addWith(String text) {
        addWith(new TextComponent(text));
    }

    /**
     * Adds a component substitution to the component. The text will inherit
     * this component's formatting
     *
     * @param component the component to substitute
     */
    public void addWith(BaseComponent component) {
        if (with == null) {
            with = new ArrayList<BaseComponent>();
        }
        component.parent = this;
        with.add(component);
    }

    @Override
    protected void toPlainText(StringVisitor builder) {
        convert(builder, false);
        super.toPlainText(builder);
    }

    @Override
    protected void toLegacyText(StringVisitor builder) {
        convert(builder, true);
        super.toLegacyText(builder);
    }

    private void convert(StringVisitor builder, boolean applyFormat) {
        String trans = TranslationRegistry.INSTANCE.translate(translate);
        if (trans.equals(translate) && fallback != null) {
            trans = fallback;
        }
        Matcher matcher = FORMAT.matcher(trans);
        int position = 0;
        int i = 0;
        while (matcher.find(position)) {
            int pos = matcher.start();
            if (pos != position) {
                if (applyFormat) {
                    addFormat(builder);
                }
                builder.append(trans.substring(position, pos));
            }
            position = matcher.end();
            String formatCode = matcher.group(2);
            switch (formatCode.charAt(0)) {
            case 's': 
            case 'd': 
                String withIndex = matcher.group(1);
                BaseComponent withComponent = with.get(withIndex != null ? Integer.parseInt(withIndex) - 1 : i++);
                if (applyFormat) {
                    withComponent.toLegacyText(builder);
                } else {
                    withComponent.toPlainText(builder);
                }
                break;
            case '%': 
                if (applyFormat) {
                    addFormat(builder);
                }
                builder.append('%');
                break;
            }
        }
        if (trans.length() != position) {
            if (applyFormat) {
                addFormat(builder);
            }
            builder.append(trans.substring(position, trans.length()));
        }
    }

    /**
     * The key into the Minecraft locale files to use for the translation. The
     * text depends on the client's locale setting. The console is always en_US
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTranslate() {
        return this.translate;
    }

    /**
     * The components to substitute into the translation
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<BaseComponent> getWith() {
        return this.with;
    }

    /**
     * The fallback, if the translation is not found
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getFallback() {
        return this.fallback;
    }

    /**
     * The key into the Minecraft locale files to use for the translation. The
     * text depends on the client's locale setting. The console is always en_US
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTranslate(final String translate) {
        this.translate = translate;
    }

    /**
     * The fallback, if the translation is not found
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFallback(final String fallback) {
        this.fallback = fallback;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TranslatableComponent(translate=" + this.getTranslate() + ", with=" + this.getWith() + ", fallback=" + this.getFallback() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TranslatableComponent() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TranslatableComponent)) return false;
        final TranslatableComponent other = (TranslatableComponent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$translate = this.getTranslate();
        final java.lang.Object other$translate = other.getTranslate();
        if (this$translate == null ? other$translate != null : !this$translate.equals(other$translate)) return false;
        final java.lang.Object this$with = this.getWith();
        final java.lang.Object other$with = other.getWith();
        if (this$with == null ? other$with != null : !this$with.equals(other$with)) return false;
        final java.lang.Object this$fallback = this.getFallback();
        final java.lang.Object other$fallback = other.getFallback();
        if (this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TranslatableComponent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $translate = this.getTranslate();
        result = result * PRIME + ($translate == null ? 43 : $translate.hashCode());
        final java.lang.Object $with = this.getWith();
        result = result * PRIME + ($with == null ? 43 : $with.hashCode());
        final java.lang.Object $fallback = this.getFallback();
        result = result * PRIME + ($fallback == null ? 43 : $fallback.hashCode());
        return result;
    }
}
