// Generated by delombok at Fri Nov 21 22:29:51 UTC 2025
package net.md_5.bungee.api.chat;

import lombok.NonNull;
import net.md_5.bungee.api.chat.objects.ChatObject;

/**
 * An object component that can be used to display objects.
 * <p>
 * It can either display a player's head or an object by a specific sprite and
 * an atlas.
 * <p>
 * Note: this was added in Minecraft 1.21.9.
 */
public final class ObjectComponent extends BaseComponent {
    private ChatObject object;

    /**
     * Creates a ObjectComponent from a given ChatObject.
     *
     * See {@link net.md_5.bungee.api.chat.objects.PlayerObject} and
     * {@link net.md_5.bungee.api.chat.objects.SpriteObject}.
     *
     * @param object the ChatObject
     */
    public ObjectComponent(@NonNull ChatObject object) {
        if (object == null) {
            throw new java.lang.NullPointerException("object is marked non-null but is null");
        }
        this.object = object;
    }

    /**
     * Creates an object component from the original to clone it.
     *
     * @param original the original for the new score component
     */
    public ObjectComponent(ObjectComponent original) {
        super(original);
        setObject(original.object);
    }

    @Override
    public ObjectComponent duplicate() {
        return new ObjectComponent(this);
    }

    @Override
    protected void toPlainText(StringVisitor builder) {
        // I guess we cannot convert this to plain text
        // builder.append( this.value );
        super.toPlainText(builder);
    }

    @Override
    protected void toLegacyText(StringVisitor builder) {
        addFormat(builder);
        // Same here...
        // builder.append( this.value );
        super.toLegacyText(builder);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ChatObject getObject() {
        return this.object;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setObject(final ChatObject object) {
        this.object = object;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ObjectComponent(object=" + this.getObject() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ObjectComponent)) return false;
        final ObjectComponent other = (ObjectComponent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$object = this.getObject();
        final java.lang.Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ObjectComponent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $object = this.getObject();
        result = result * PRIME + ($object == null ? 43 : $object.hashCode());
        return result;
    }
}
