/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class TabCompleteRequest
extends DefinedPacket {
    private int transactionId;
    private String cursor;
    private boolean assumeCommand;
    private boolean hasPositon;
    private long position;

    public TabCompleteRequest(int transactionId, String cursor) {
        this.transactionId = transactionId;
        this.cursor = cursor;
    }

    public TabCompleteRequest(String cursor, boolean assumeCommand, boolean hasPosition, long position) {
        this.cursor = cursor;
        this.assumeCommand = assumeCommand;
        this.hasPositon = hasPosition;
        this.position = position;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 393) {
            this.transactionId = TabCompleteRequest.readVarInt(buf);
        }
        this.cursor = TabCompleteRequest.readString(buf, protocolVersion > 393 ? 32500 : (protocolVersion == 393 ? 256 : Short.MAX_VALUE));
        if (protocolVersion < 393) {
            if (protocolVersion >= 107) {
                this.assumeCommand = buf.readBoolean();
            }
            if (this.hasPositon = buf.readBoolean()) {
                this.position = buf.readLong();
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 393) {
            TabCompleteRequest.writeVarInt(this.transactionId, buf);
        }
        TabCompleteRequest.writeString(this.cursor, buf);
        if (protocolVersion < 393) {
            if (protocolVersion >= 107) {
                buf.writeBoolean(this.assumeCommand);
            }
            buf.writeBoolean(this.hasPositon);
            if (this.hasPositon) {
                buf.writeLong(this.position);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public int getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public String getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean isAssumeCommand() {
        return this.assumeCommand;
    }

    @Generated
    public boolean isHasPositon() {
        return this.hasPositon;
    }

    @Generated
    public long getPosition() {
        return this.position;
    }

    @Generated
    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    @Generated
    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    @Generated
    public void setAssumeCommand(boolean assumeCommand) {
        this.assumeCommand = assumeCommand;
    }

    @Generated
    public void setHasPositon(boolean hasPositon) {
        this.hasPositon = hasPositon;
    }

    @Generated
    public void setPosition(long position) {
        this.position = position;
    }

    @Override
    @Generated
    public String toString() {
        return "TabCompleteRequest(transactionId=" + this.getTransactionId() + ", cursor=" + this.getCursor() + ", assumeCommand=" + this.isAssumeCommand() + ", hasPositon=" + this.isHasPositon() + ", position=" + this.getPosition() + ")";
    }

    @Generated
    public TabCompleteRequest() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabCompleteRequest)) {
            return false;
        }
        TabCompleteRequest other = (TabCompleteRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        if (this.isAssumeCommand() != other.isAssumeCommand()) {
            return false;
        }
        if (this.isHasPositon() != other.isHasPositon()) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TabCompleteRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        result = result * 59 + (this.isAssumeCommand() ? 79 : 97);
        result = result * 59 + (this.isHasPositon() ? 79 : 97);
        long $position = this.getPosition();
        result = result * 59 + (int)($position >>> 32 ^ $position);
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }
}

