/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.ServerDomainSocketChannel;
import io.netty.channel.uring.AbstractIoUringServerChannel;
import io.netty.channel.uring.IoUringDomainSocketChannel;
import io.netty.channel.uring.IoUringServerSocketChannelConfig;
import io.netty.channel.uring.LinuxSocket;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public final class IoUringServerDomainSocketChannel
extends AbstractIoUringServerChannel
implements ServerDomainSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IoUringServerDomainSocketChannel.class);
    private final IoUringServerSocketChannelConfig config = new IoUringServerSocketChannelConfig(this);
    private volatile DomainSocketAddress local;

    public IoUringServerDomainSocketChannel() {
        super(LinuxSocket.newSocketDomain(), false);
        this.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                File socketFile;
                boolean success;
                if (IoUringServerDomainSocketChannel.this.local != null && !(success = (socketFile = new File(IoUringServerDomainSocketChannel.this.local.path())).delete()) && logger.isDebugEnabled()) {
                    logger.debug("Failed to delete a domain socket file: {}", (Object)IoUringServerDomainSocketChannel.this.local.path());
                }
            }
        });
    }

    @Override
    Channel newChildChannel(int fd, ByteBuffer acceptedAddressMemory) throws Exception {
        return new IoUringDomainSocketChannel((Channel)this, new LinuxSocket(fd));
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public DomainSocketAddress localAddress() {
        return this.local;
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.socket.bind(localAddress);
        this.socket.listen(this.config.getBacklog());
        this.local = (DomainSocketAddress)localAddress;
        this.active = true;
    }
}

