/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.Property;

public class LoginSuccess
extends DefinedPacket {
    private UUID uuid;
    private String username;
    private Property[] properties;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.uuid = protocolVersion >= 735 ? LoginSuccess.readUUID(buf) : UUID.fromString(LoginSuccess.readString(buf));
        this.username = LoginSuccess.readString(buf);
        if (protocolVersion >= 759) {
            this.properties = LoginSuccess.readProperties(buf);
        }
        if (protocolVersion >= 766 && protocolVersion < 768) {
            buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 735) {
            LoginSuccess.writeUUID(this.uuid, buf);
        } else {
            LoginSuccess.writeString(this.uuid.toString(), buf);
        }
        LoginSuccess.writeString(this.username, buf);
        if (protocolVersion >= 759) {
            LoginSuccess.writeProperties(this.properties, buf);
        }
        if (protocolVersion >= 766 && protocolVersion < 768) {
            buf.writeBoolean(true);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public Property[] getProperties() {
        return this.properties;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setProperties(Property[] properties) {
        this.properties = properties;
    }

    @Override
    @Generated
    public String toString() {
        return "LoginSuccess(uuid=" + this.getUuid() + ", username=" + this.getUsername() + ", properties=" + Arrays.deepToString(this.getProperties()) + ")";
    }

    @Generated
    public LoginSuccess() {
    }

    @Generated
    public LoginSuccess(UUID uuid, String username, Property[] properties) {
        this.uuid = uuid;
        this.username = username;
        this.properties = properties;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginSuccess)) {
            return false;
        }
        LoginSuccess other = (LoginSuccess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        return Arrays.deepEquals(this.getProperties(), other.getProperties());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoginSuccess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        return result;
    }
}

