/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import lombok.Generated;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class StringTag
implements TypedTag {
    private String value;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.countBytes(36L);
        String string = input.readUTF();
        limiter.countBytes(string.length(), 2L);
        this.value = string;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(this.value, "string value cannot be null");
        output.writeUTF(this.value);
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringTag)) {
            return false;
        }
        StringTag other = (StringTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StringTag(value=" + this.getValue() + ")";
    }

    @Generated
    public StringTag() {
    }

    @Generated
    public StringTag(String value) {
        this.value = value;
    }
}

