/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.uring.IoUringBufferRingAllocator;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractIoUringBufferRingAllocator
implements IoUringBufferRingAllocator {
    private final ByteBufAllocator allocator;
    private final boolean largeAllocation;

    protected AbstractIoUringBufferRingAllocator(ByteBufAllocator allocator, boolean largeAllocation) {
        this.allocator = Objects.requireNonNull(allocator, "allocator");
        this.largeAllocation = largeAllocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void allocateBatch(Consumer<ByteBuf> consumer, int number) {
        if (this.largeAllocation) {
            int bufferSize = this.nextBufferSize();
            ByteBuf buffer = this.allocator.directBuffer(this.nextBufferSize() * number);
            try {
                for (int i = 0; i < number; ++i) {
                    consumer.accept(buffer.retainedSlice(i * bufferSize, bufferSize).setIndex(0, 0));
                }
            }
            finally {
                buffer.release();
            }
        } else {
            IoUringBufferRingAllocator.super.allocateBatch(consumer, number);
        }
    }

    @Override
    public final ByteBuf allocate() {
        return this.allocator.directBuffer(this.nextBufferSize());
    }

    @Override
    public void lastBytesRead(int attempted, int actual) {
    }

    protected abstract int nextBufferSize();
}

